package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core._
import io.github.vigoo.zioaws.core.aspects._
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.docdb.paginators._
import software.amazon.awssdk.services.docdb.{ DocDbAsyncClient, DocDbAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters._
package object docdb {
  type DocDb = Has[DocDb.Service]
  object DocDb {
    trait Service extends AspectSupport[Service] {
      val api: DocDbAsyncClient
      def copyDBClusterSnapshot(request: model.CopyDbClusterSnapshotRequest): IO[AwsError, model.CopyDbClusterSnapshotResponse.ReadOnly]
      def modifyDBInstance(request: model.ModifyDbInstanceRequest): IO[AwsError, model.ModifyDbInstanceResponse.ReadOnly]
      def addTagsToResource(request: model.AddTagsToResourceRequest): IO[AwsError, scala.Unit]
      def describeDBClusterSnapshots(request: model.DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[Any, AwsError, model.DBClusterSnapshot.ReadOnly]
      def resetDBClusterParameterGroup(request: model.ResetDbClusterParameterGroupRequest): IO[AwsError, model.ResetDbClusterParameterGroupResponse.ReadOnly]
      def removeSourceIdentifierFromSubscription(request: model.RemoveSourceIdentifierFromSubscriptionRequest): IO[AwsError, model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly]
      def describeEngineDefaultClusterParameters(request: model.DescribeEngineDefaultClusterParametersRequest): IO[AwsError, model.DescribeEngineDefaultClusterParametersResponse.ReadOnly]
      def createDBSubnetGroup(request: model.CreateDbSubnetGroupRequest): IO[AwsError, model.CreateDbSubnetGroupResponse.ReadOnly]
      def copyDBClusterParameterGroup(request: model.CopyDbClusterParameterGroupRequest): IO[AwsError, model.CopyDbClusterParameterGroupResponse.ReadOnly]
      def describePendingMaintenanceActions(request: model.DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[Any, AwsError, model.ResourcePendingMaintenanceActions.ReadOnly]
      def deleteDBClusterParameterGroup(request: model.DeleteDbClusterParameterGroupRequest): IO[AwsError, scala.Unit]
      def removeFromGlobalCluster(request: model.RemoveFromGlobalClusterRequest): IO[AwsError, model.RemoveFromGlobalClusterResponse.ReadOnly]
      def modifyDBClusterParameterGroup(request: model.ModifyDbClusterParameterGroupRequest): IO[AwsError, model.ModifyDbClusterParameterGroupResponse.ReadOnly]
      def stopDBCluster(request: model.StopDbClusterRequest): IO[AwsError, model.StopDbClusterResponse.ReadOnly]
      def createDBCluster(request: model.CreateDbClusterRequest): IO[AwsError, model.CreateDbClusterResponse.ReadOnly]
      def describeCertificates(request: model.DescribeCertificatesRequest): zio.stream.ZStream[Any, AwsError, model.Certificate.ReadOnly]
      def deleteEventSubscription(request: model.DeleteEventSubscriptionRequest): IO[AwsError, model.DeleteEventSubscriptionResponse.ReadOnly]
      def describeDBSubnetGroups(request: model.DescribeDbSubnetGroupsRequest): zio.stream.ZStream[Any, AwsError, model.DBSubnetGroup.ReadOnly]
      def createDBClusterParameterGroup(request: model.CreateDbClusterParameterGroupRequest): IO[AwsError, model.CreateDbClusterParameterGroupResponse.ReadOnly]
      def modifyDBCluster(request: model.ModifyDbClusterRequest): IO[AwsError, model.ModifyDbClusterResponse.ReadOnly]
      def removeTagsFromResource(request: model.RemoveTagsFromResourceRequest): IO[AwsError, scala.Unit]
      def applyPendingMaintenanceAction(request: model.ApplyPendingMaintenanceActionRequest): IO[AwsError, model.ApplyPendingMaintenanceActionResponse.ReadOnly]
      def modifyDBSubnetGroup(request: model.ModifyDbSubnetGroupRequest): IO[AwsError, model.ModifyDbSubnetGroupResponse.ReadOnly]
      def modifyGlobalCluster(request: model.ModifyGlobalClusterRequest): IO[AwsError, model.ModifyGlobalClusterResponse.ReadOnly]
      def restoreDBClusterFromSnapshot(request: model.RestoreDbClusterFromSnapshotRequest): IO[AwsError, model.RestoreDbClusterFromSnapshotResponse.ReadOnly]
      def describeGlobalClusters(request: model.DescribeGlobalClustersRequest): zio.stream.ZStream[Any, AwsError, model.GlobalCluster.ReadOnly]
      def describeDBClusterParameters(request: model.DescribeDbClusterParametersRequest): zio.stream.ZStream[Any, AwsError, model.Parameter.ReadOnly]
      def modifyEventSubscription(request: model.ModifyEventSubscriptionRequest): IO[AwsError, model.ModifyEventSubscriptionResponse.ReadOnly]
      def createDBInstance(request: model.CreateDbInstanceRequest): IO[AwsError, model.CreateDbInstanceResponse.ReadOnly]
      def deleteDBClusterSnapshot(request: model.DeleteDbClusterSnapshotRequest): IO[AwsError, model.DeleteDbClusterSnapshotResponse.ReadOnly]
      def startDBCluster(request: model.StartDbClusterRequest): IO[AwsError, model.StartDbClusterResponse.ReadOnly]
      def modifyDBClusterSnapshotAttribute(request: model.ModifyDbClusterSnapshotAttributeRequest): IO[AwsError, model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly]
      def describeEventCategories(request: model.DescribeEventCategoriesRequest): IO[AwsError, model.DescribeEventCategoriesResponse.ReadOnly]
      def deleteDBSubnetGroup(request: model.DeleteDbSubnetGroupRequest): IO[AwsError, scala.Unit]
      def rebootDBInstance(request: model.RebootDbInstanceRequest): IO[AwsError, model.RebootDbInstanceResponse.ReadOnly]
      def describeDBClusterParameterGroups(request: model.DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, model.DBClusterParameterGroup.ReadOnly]
      def createEventSubscription(request: model.CreateEventSubscriptionRequest): IO[AwsError, model.CreateEventSubscriptionResponse.ReadOnly]
      def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly]
      def restoreDBClusterToPointInTime(request: model.RestoreDbClusterToPointInTimeRequest): IO[AwsError, model.RestoreDbClusterToPointInTimeResponse.ReadOnly]
      def describeDBClusters(request: model.DescribeDbClustersRequest): zio.stream.ZStream[Any, AwsError, model.DBCluster.ReadOnly]
      def failoverDBCluster(request: model.FailoverDbClusterRequest): IO[AwsError, model.FailoverDbClusterResponse.ReadOnly]
      def describeEventSubscriptions(request: model.DescribeEventSubscriptionsRequest): zio.stream.ZStream[Any, AwsError, model.EventSubscription.ReadOnly]
      def describeDBInstances(request: model.DescribeDbInstancesRequest): zio.stream.ZStream[Any, AwsError, model.DBInstance.ReadOnly]
      def createDBClusterSnapshot(request: model.CreateDbClusterSnapshotRequest): IO[AwsError, model.CreateDbClusterSnapshotResponse.ReadOnly]
      def deleteDBCluster(request: model.DeleteDbClusterRequest): IO[AwsError, model.DeleteDbClusterResponse.ReadOnly]
      def deleteGlobalCluster(request: model.DeleteGlobalClusterRequest): IO[AwsError, model.DeleteGlobalClusterResponse.ReadOnly]
      def deleteDBInstance(request: model.DeleteDbInstanceRequest): IO[AwsError, model.DeleteDbInstanceResponse.ReadOnly]
      def addSourceIdentifierToSubscription(request: model.AddSourceIdentifierToSubscriptionRequest): IO[AwsError, model.AddSourceIdentifierToSubscriptionResponse.ReadOnly]
      def describeDBEngineVersions(request: model.DescribeDbEngineVersionsRequest): zio.stream.ZStream[Any, AwsError, model.DBEngineVersion.ReadOnly]
      def createGlobalCluster(request: model.CreateGlobalClusterRequest): IO[AwsError, model.CreateGlobalClusterResponse.ReadOnly]
      def describeOrderableDBInstanceOptions(request: model.DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[Any, AwsError, model.OrderableDBInstanceOption.ReadOnly]
      def describeDBClusterSnapshotAttributes(request: model.DescribeDbClusterSnapshotAttributesRequest): IO[AwsError, model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly]
      def describeEvents(request: model.DescribeEventsRequest): zio.stream.ZStream[Any, AwsError, model.Event.ReadOnly]
    }
    object DocDbMock extends zio.test.mock.Mock[DocDb] {
      object CopyDBClusterSnapshot extends Effect[model.CopyDbClusterSnapshotRequest, AwsError, model.CopyDbClusterSnapshotResponse.ReadOnly]
      object ModifyDBInstance extends Effect[model.ModifyDbInstanceRequest, AwsError, model.ModifyDbInstanceResponse.ReadOnly]
      object AddTagsToResource extends Effect[model.AddTagsToResourceRequest, AwsError, scala.Unit]
      object DescribeDBClusterSnapshots extends Stream[model.DescribeDbClusterSnapshotsRequest, AwsError, model.DBClusterSnapshot.ReadOnly]
      object ResetDBClusterParameterGroup extends Effect[model.ResetDbClusterParameterGroupRequest, AwsError, model.ResetDbClusterParameterGroupResponse.ReadOnly]
      object RemoveSourceIdentifierFromSubscription extends Effect[model.RemoveSourceIdentifierFromSubscriptionRequest, AwsError, model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly]
      object DescribeEngineDefaultClusterParameters extends Effect[model.DescribeEngineDefaultClusterParametersRequest, AwsError, model.DescribeEngineDefaultClusterParametersResponse.ReadOnly]
      object CreateDBSubnetGroup extends Effect[model.CreateDbSubnetGroupRequest, AwsError, model.CreateDbSubnetGroupResponse.ReadOnly]
      object CopyDBClusterParameterGroup extends Effect[model.CopyDbClusterParameterGroupRequest, AwsError, model.CopyDbClusterParameterGroupResponse.ReadOnly]
      object DescribePendingMaintenanceActions extends Stream[model.DescribePendingMaintenanceActionsRequest, AwsError, model.ResourcePendingMaintenanceActions.ReadOnly]
      object DeleteDBClusterParameterGroup extends Effect[model.DeleteDbClusterParameterGroupRequest, AwsError, scala.Unit]
      object RemoveFromGlobalCluster extends Effect[model.RemoveFromGlobalClusterRequest, AwsError, model.RemoveFromGlobalClusterResponse.ReadOnly]
      object ModifyDBClusterParameterGroup extends Effect[model.ModifyDbClusterParameterGroupRequest, AwsError, model.ModifyDbClusterParameterGroupResponse.ReadOnly]
      object StopDBCluster extends Effect[model.StopDbClusterRequest, AwsError, model.StopDbClusterResponse.ReadOnly]
      object CreateDBCluster extends Effect[model.CreateDbClusterRequest, AwsError, model.CreateDbClusterResponse.ReadOnly]
      object DescribeCertificates extends Stream[model.DescribeCertificatesRequest, AwsError, model.Certificate.ReadOnly]
      object DeleteEventSubscription extends Effect[model.DeleteEventSubscriptionRequest, AwsError, model.DeleteEventSubscriptionResponse.ReadOnly]
      object DescribeDBSubnetGroups extends Stream[model.DescribeDbSubnetGroupsRequest, AwsError, model.DBSubnetGroup.ReadOnly]
      object CreateDBClusterParameterGroup extends Effect[model.CreateDbClusterParameterGroupRequest, AwsError, model.CreateDbClusterParameterGroupResponse.ReadOnly]
      object ModifyDBCluster extends Effect[model.ModifyDbClusterRequest, AwsError, model.ModifyDbClusterResponse.ReadOnly]
      object RemoveTagsFromResource extends Effect[model.RemoveTagsFromResourceRequest, AwsError, scala.Unit]
      object ApplyPendingMaintenanceAction extends Effect[model.ApplyPendingMaintenanceActionRequest, AwsError, model.ApplyPendingMaintenanceActionResponse.ReadOnly]
      object ModifyDBSubnetGroup extends Effect[model.ModifyDbSubnetGroupRequest, AwsError, model.ModifyDbSubnetGroupResponse.ReadOnly]
      object ModifyGlobalCluster extends Effect[model.ModifyGlobalClusterRequest, AwsError, model.ModifyGlobalClusterResponse.ReadOnly]
      object RestoreDBClusterFromSnapshot extends Effect[model.RestoreDbClusterFromSnapshotRequest, AwsError, model.RestoreDbClusterFromSnapshotResponse.ReadOnly]
      object DescribeGlobalClusters extends Stream[model.DescribeGlobalClustersRequest, AwsError, model.GlobalCluster.ReadOnly]
      object DescribeDBClusterParameters extends Stream[model.DescribeDbClusterParametersRequest, AwsError, model.Parameter.ReadOnly]
      object ModifyEventSubscription extends Effect[model.ModifyEventSubscriptionRequest, AwsError, model.ModifyEventSubscriptionResponse.ReadOnly]
      object CreateDBInstance extends Effect[model.CreateDbInstanceRequest, AwsError, model.CreateDbInstanceResponse.ReadOnly]
      object DeleteDBClusterSnapshot extends Effect[model.DeleteDbClusterSnapshotRequest, AwsError, model.DeleteDbClusterSnapshotResponse.ReadOnly]
      object StartDBCluster extends Effect[model.StartDbClusterRequest, AwsError, model.StartDbClusterResponse.ReadOnly]
      object ModifyDBClusterSnapshotAttribute extends Effect[model.ModifyDbClusterSnapshotAttributeRequest, AwsError, model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly]
      object DescribeEventCategories extends Effect[model.DescribeEventCategoriesRequest, AwsError, model.DescribeEventCategoriesResponse.ReadOnly]
      object DeleteDBSubnetGroup extends Effect[model.DeleteDbSubnetGroupRequest, AwsError, scala.Unit]
      object RebootDBInstance extends Effect[model.RebootDbInstanceRequest, AwsError, model.RebootDbInstanceResponse.ReadOnly]
      object DescribeDBClusterParameterGroups extends Stream[model.DescribeDbClusterParameterGroupsRequest, AwsError, model.DBClusterParameterGroup.ReadOnly]
      object CreateEventSubscription extends Effect[model.CreateEventSubscriptionRequest, AwsError, model.CreateEventSubscriptionResponse.ReadOnly]
      object ListTagsForResource extends Effect[model.ListTagsForResourceRequest, AwsError, model.ListTagsForResourceResponse.ReadOnly]
      object RestoreDBClusterToPointInTime extends Effect[model.RestoreDbClusterToPointInTimeRequest, AwsError, model.RestoreDbClusterToPointInTimeResponse.ReadOnly]
      object DescribeDBClusters extends Stream[model.DescribeDbClustersRequest, AwsError, model.DBCluster.ReadOnly]
      object FailoverDBCluster extends Effect[model.FailoverDbClusterRequest, AwsError, model.FailoverDbClusterResponse.ReadOnly]
      object DescribeEventSubscriptions extends Stream[model.DescribeEventSubscriptionsRequest, AwsError, model.EventSubscription.ReadOnly]
      object DescribeDBInstances extends Stream[model.DescribeDbInstancesRequest, AwsError, model.DBInstance.ReadOnly]
      object CreateDBClusterSnapshot extends Effect[model.CreateDbClusterSnapshotRequest, AwsError, model.CreateDbClusterSnapshotResponse.ReadOnly]
      object DeleteDBCluster extends Effect[model.DeleteDbClusterRequest, AwsError, model.DeleteDbClusterResponse.ReadOnly]
      object DeleteGlobalCluster extends Effect[model.DeleteGlobalClusterRequest, AwsError, model.DeleteGlobalClusterResponse.ReadOnly]
      object DeleteDBInstance extends Effect[model.DeleteDbInstanceRequest, AwsError, model.DeleteDbInstanceResponse.ReadOnly]
      object AddSourceIdentifierToSubscription extends Effect[model.AddSourceIdentifierToSubscriptionRequest, AwsError, model.AddSourceIdentifierToSubscriptionResponse.ReadOnly]
      object DescribeDBEngineVersions extends Stream[model.DescribeDbEngineVersionsRequest, AwsError, model.DBEngineVersion.ReadOnly]
      object CreateGlobalCluster extends Effect[model.CreateGlobalClusterRequest, AwsError, model.CreateGlobalClusterResponse.ReadOnly]
      object DescribeOrderableDBInstanceOptions extends Stream[model.DescribeOrderableDbInstanceOptionsRequest, AwsError, model.OrderableDBInstanceOption.ReadOnly]
      object DescribeDBClusterSnapshotAttributes extends Effect[model.DescribeDbClusterSnapshotAttributesRequest, AwsError, model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly]
      object DescribeEvents extends Stream[model.DescribeEventsRequest, AwsError, model.Event.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], DocDb] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new DocDb.Service {
            val api: DocDbAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): DocDb.Service = this
            def copyDBClusterSnapshot(request: model.CopyDbClusterSnapshotRequest): IO[AwsError, model.CopyDbClusterSnapshotResponse.ReadOnly] = proxy(CopyDBClusterSnapshot, request)
            def modifyDBInstance(request: model.ModifyDbInstanceRequest): IO[AwsError, model.ModifyDbInstanceResponse.ReadOnly] = proxy(ModifyDBInstance, request)
            def addTagsToResource(request: model.AddTagsToResourceRequest): IO[AwsError, scala.Unit] = proxy(AddTagsToResource, request)
            def describeDBClusterSnapshots(request: model.DescribeDbClusterSnapshotsRequest): ZStream[Any, AwsError, model.DBClusterSnapshot.ReadOnly] = rts.unsafeRun(proxy(DescribeDBClusterSnapshots, request))
            def resetDBClusterParameterGroup(request: model.ResetDbClusterParameterGroupRequest): IO[AwsError, model.ResetDbClusterParameterGroupResponse.ReadOnly] = proxy(ResetDBClusterParameterGroup, request)
            def removeSourceIdentifierFromSubscription(request: model.RemoveSourceIdentifierFromSubscriptionRequest): IO[AwsError, model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly] = proxy(RemoveSourceIdentifierFromSubscription, request)
            def describeEngineDefaultClusterParameters(request: model.DescribeEngineDefaultClusterParametersRequest): IO[AwsError, model.DescribeEngineDefaultClusterParametersResponse.ReadOnly] = proxy(DescribeEngineDefaultClusterParameters, request)
            def createDBSubnetGroup(request: model.CreateDbSubnetGroupRequest): IO[AwsError, model.CreateDbSubnetGroupResponse.ReadOnly] = proxy(CreateDBSubnetGroup, request)
            def copyDBClusterParameterGroup(request: model.CopyDbClusterParameterGroupRequest): IO[AwsError, model.CopyDbClusterParameterGroupResponse.ReadOnly] = proxy(CopyDBClusterParameterGroup, request)
            def describePendingMaintenanceActions(request: model.DescribePendingMaintenanceActionsRequest): ZStream[Any, AwsError, model.ResourcePendingMaintenanceActions.ReadOnly] = rts.unsafeRun(proxy(DescribePendingMaintenanceActions, request))
            def deleteDBClusterParameterGroup(request: model.DeleteDbClusterParameterGroupRequest): IO[AwsError, scala.Unit] = proxy(DeleteDBClusterParameterGroup, request)
            def removeFromGlobalCluster(request: model.RemoveFromGlobalClusterRequest): IO[AwsError, model.RemoveFromGlobalClusterResponse.ReadOnly] = proxy(RemoveFromGlobalCluster, request)
            def modifyDBClusterParameterGroup(request: model.ModifyDbClusterParameterGroupRequest): IO[AwsError, model.ModifyDbClusterParameterGroupResponse.ReadOnly] = proxy(ModifyDBClusterParameterGroup, request)
            def stopDBCluster(request: model.StopDbClusterRequest): IO[AwsError, model.StopDbClusterResponse.ReadOnly] = proxy(StopDBCluster, request)
            def createDBCluster(request: model.CreateDbClusterRequest): IO[AwsError, model.CreateDbClusterResponse.ReadOnly] = proxy(CreateDBCluster, request)
            def describeCertificates(request: model.DescribeCertificatesRequest): ZStream[Any, AwsError, model.Certificate.ReadOnly] = rts.unsafeRun(proxy(DescribeCertificates, request))
            def deleteEventSubscription(request: model.DeleteEventSubscriptionRequest): IO[AwsError, model.DeleteEventSubscriptionResponse.ReadOnly] = proxy(DeleteEventSubscription, request)
            def describeDBSubnetGroups(request: model.DescribeDbSubnetGroupsRequest): ZStream[Any, AwsError, model.DBSubnetGroup.ReadOnly] = rts.unsafeRun(proxy(DescribeDBSubnetGroups, request))
            def createDBClusterParameterGroup(request: model.CreateDbClusterParameterGroupRequest): IO[AwsError, model.CreateDbClusterParameterGroupResponse.ReadOnly] = proxy(CreateDBClusterParameterGroup, request)
            def modifyDBCluster(request: model.ModifyDbClusterRequest): IO[AwsError, model.ModifyDbClusterResponse.ReadOnly] = proxy(ModifyDBCluster, request)
            def removeTagsFromResource(request: model.RemoveTagsFromResourceRequest): IO[AwsError, scala.Unit] = proxy(RemoveTagsFromResource, request)
            def applyPendingMaintenanceAction(request: model.ApplyPendingMaintenanceActionRequest): IO[AwsError, model.ApplyPendingMaintenanceActionResponse.ReadOnly] = proxy(ApplyPendingMaintenanceAction, request)
            def modifyDBSubnetGroup(request: model.ModifyDbSubnetGroupRequest): IO[AwsError, model.ModifyDbSubnetGroupResponse.ReadOnly] = proxy(ModifyDBSubnetGroup, request)
            def modifyGlobalCluster(request: model.ModifyGlobalClusterRequest): IO[AwsError, model.ModifyGlobalClusterResponse.ReadOnly] = proxy(ModifyGlobalCluster, request)
            def restoreDBClusterFromSnapshot(request: model.RestoreDbClusterFromSnapshotRequest): IO[AwsError, model.RestoreDbClusterFromSnapshotResponse.ReadOnly] = proxy(RestoreDBClusterFromSnapshot, request)
            def describeGlobalClusters(request: model.DescribeGlobalClustersRequest): ZStream[Any, AwsError, model.GlobalCluster.ReadOnly] = rts.unsafeRun(proxy(DescribeGlobalClusters, request))
            def describeDBClusterParameters(request: model.DescribeDbClusterParametersRequest): ZStream[Any, AwsError, model.Parameter.ReadOnly] = rts.unsafeRun(proxy(DescribeDBClusterParameters, request))
            def modifyEventSubscription(request: model.ModifyEventSubscriptionRequest): IO[AwsError, model.ModifyEventSubscriptionResponse.ReadOnly] = proxy(ModifyEventSubscription, request)
            def createDBInstance(request: model.CreateDbInstanceRequest): IO[AwsError, model.CreateDbInstanceResponse.ReadOnly] = proxy(CreateDBInstance, request)
            def deleteDBClusterSnapshot(request: model.DeleteDbClusterSnapshotRequest): IO[AwsError, model.DeleteDbClusterSnapshotResponse.ReadOnly] = proxy(DeleteDBClusterSnapshot, request)
            def startDBCluster(request: model.StartDbClusterRequest): IO[AwsError, model.StartDbClusterResponse.ReadOnly] = proxy(StartDBCluster, request)
            def modifyDBClusterSnapshotAttribute(request: model.ModifyDbClusterSnapshotAttributeRequest): IO[AwsError, model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly] = proxy(ModifyDBClusterSnapshotAttribute, request)
            def describeEventCategories(request: model.DescribeEventCategoriesRequest): IO[AwsError, model.DescribeEventCategoriesResponse.ReadOnly] = proxy(DescribeEventCategories, request)
            def deleteDBSubnetGroup(request: model.DeleteDbSubnetGroupRequest): IO[AwsError, scala.Unit] = proxy(DeleteDBSubnetGroup, request)
            def rebootDBInstance(request: model.RebootDbInstanceRequest): IO[AwsError, model.RebootDbInstanceResponse.ReadOnly] = proxy(RebootDBInstance, request)
            def describeDBClusterParameterGroups(request: model.DescribeDbClusterParameterGroupsRequest): ZStream[Any, AwsError, model.DBClusterParameterGroup.ReadOnly] = rts.unsafeRun(proxy(DescribeDBClusterParameterGroups, request))
            def createEventSubscription(request: model.CreateEventSubscriptionRequest): IO[AwsError, model.CreateEventSubscriptionResponse.ReadOnly] = proxy(CreateEventSubscription, request)
            def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = proxy(ListTagsForResource, request)
            def restoreDBClusterToPointInTime(request: model.RestoreDbClusterToPointInTimeRequest): IO[AwsError, model.RestoreDbClusterToPointInTimeResponse.ReadOnly] = proxy(RestoreDBClusterToPointInTime, request)
            def describeDBClusters(request: model.DescribeDbClustersRequest): ZStream[Any, AwsError, model.DBCluster.ReadOnly] = rts.unsafeRun(proxy(DescribeDBClusters, request))
            def failoverDBCluster(request: model.FailoverDbClusterRequest): IO[AwsError, model.FailoverDbClusterResponse.ReadOnly] = proxy(FailoverDBCluster, request)
            def describeEventSubscriptions(request: model.DescribeEventSubscriptionsRequest): ZStream[Any, AwsError, model.EventSubscription.ReadOnly] = rts.unsafeRun(proxy(DescribeEventSubscriptions, request))
            def describeDBInstances(request: model.DescribeDbInstancesRequest): ZStream[Any, AwsError, model.DBInstance.ReadOnly] = rts.unsafeRun(proxy(DescribeDBInstances, request))
            def createDBClusterSnapshot(request: model.CreateDbClusterSnapshotRequest): IO[AwsError, model.CreateDbClusterSnapshotResponse.ReadOnly] = proxy(CreateDBClusterSnapshot, request)
            def deleteDBCluster(request: model.DeleteDbClusterRequest): IO[AwsError, model.DeleteDbClusterResponse.ReadOnly] = proxy(DeleteDBCluster, request)
            def deleteGlobalCluster(request: model.DeleteGlobalClusterRequest): IO[AwsError, model.DeleteGlobalClusterResponse.ReadOnly] = proxy(DeleteGlobalCluster, request)
            def deleteDBInstance(request: model.DeleteDbInstanceRequest): IO[AwsError, model.DeleteDbInstanceResponse.ReadOnly] = proxy(DeleteDBInstance, request)
            def addSourceIdentifierToSubscription(request: model.AddSourceIdentifierToSubscriptionRequest): IO[AwsError, model.AddSourceIdentifierToSubscriptionResponse.ReadOnly] = proxy(AddSourceIdentifierToSubscription, request)
            def describeDBEngineVersions(request: model.DescribeDbEngineVersionsRequest): ZStream[Any, AwsError, model.DBEngineVersion.ReadOnly] = rts.unsafeRun(proxy(DescribeDBEngineVersions, request))
            def createGlobalCluster(request: model.CreateGlobalClusterRequest): IO[AwsError, model.CreateGlobalClusterResponse.ReadOnly] = proxy(CreateGlobalCluster, request)
            def describeOrderableDBInstanceOptions(request: model.DescribeOrderableDbInstanceOptionsRequest): ZStream[Any, AwsError, model.OrderableDBInstanceOption.ReadOnly] = rts.unsafeRun(proxy(DescribeOrderableDBInstanceOptions, request))
            def describeDBClusterSnapshotAttributes(request: model.DescribeDbClusterSnapshotAttributesRequest): IO[AwsError, model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly] = proxy(DescribeDBClusterSnapshotAttributes, request)
            def describeEvents(request: model.DescribeEventsRequest): ZStream[Any, AwsError, model.Event.ReadOnly] = rts.unsafeRun(proxy(DescribeEvents, request))
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, DocDb] = customized(identity)
  def customized(customization: DocDbAsyncClientBuilder => DocDbAsyncClientBuilder): ZLayer[AwsConfig, Throwable, DocDb] = managed(customization).toLayer
  def managed(customization: DocDbAsyncClientBuilder => DocDbAsyncClientBuilder): ZManaged[AwsConfig, Throwable, DocDb.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = DocDbAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[DocDbAsyncClient, DocDbAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[DocDbAsyncClient, DocDbAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new DocDbImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class DocDbImpl[R](override val api: DocDbAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends DocDb.Service with AwsServiceBase[R, DocDbImpl] {
    override val serviceName: String = "DocDb"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): DocDbImpl[R1] = new DocDbImpl(api, newAspect, r)
    def copyDBClusterSnapshot(request: model.CopyDbClusterSnapshotRequest): IO[AwsError, model.CopyDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest, software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotResponse]("copyDBClusterSnapshot", api.copyDBClusterSnapshot)(request.buildAwsValue()).map(model.CopyDbClusterSnapshotResponse.wrap).provide(r)
    def modifyDBInstance(request: model.ModifyDbInstanceRequest): IO[AwsError, model.ModifyDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest, software.amazon.awssdk.services.docdb.model.ModifyDbInstanceResponse]("modifyDBInstance", api.modifyDBInstance)(request.buildAwsValue()).map(model.ModifyDbInstanceResponse.wrap).provide(r)
    def addTagsToResource(request: model.AddTagsToResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest, software.amazon.awssdk.services.docdb.model.AddTagsToResourceResponse]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue()).unit.provide(r)
    def describeDBClusterSnapshots(request: model.DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[Any, AwsError, model.DBClusterSnapshot.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest, software.amazon.awssdk.services.docdb.model.DBClusterSnapshot, software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterSnapshotsPublisher]("describeDBClusterSnapshots", api.describeDBClusterSnapshotsPaginator, _.dbClusterSnapshots())(request.buildAwsValue()).map(item => model.DBClusterSnapshot.wrap(item)).provide(r)
    def resetDBClusterParameterGroup(request: model.ResetDbClusterParameterGroupRequest): IO[AwsError, model.ResetDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest, software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupResponse]("resetDBClusterParameterGroup", api.resetDBClusterParameterGroup)(request.buildAwsValue()).map(model.ResetDbClusterParameterGroupResponse.wrap).provide(r)
    def removeSourceIdentifierFromSubscription(request: model.RemoveSourceIdentifierFromSubscriptionRequest): IO[AwsError, model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest, software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse]("removeSourceIdentifierFromSubscription", api.removeSourceIdentifierFromSubscription)(request.buildAwsValue()).map(model.RemoveSourceIdentifierFromSubscriptionResponse.wrap).provide(r)
    def describeEngineDefaultClusterParameters(request: model.DescribeEngineDefaultClusterParametersRequest): IO[AwsError, model.DescribeEngineDefaultClusterParametersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest, software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersResponse]("describeEngineDefaultClusterParameters", api.describeEngineDefaultClusterParameters)(request.buildAwsValue()).map(model.DescribeEngineDefaultClusterParametersResponse.wrap).provide(r)
    def createDBSubnetGroup(request: model.CreateDbSubnetGroupRequest): IO[AwsError, model.CreateDbSubnetGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest, software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupResponse]("createDBSubnetGroup", api.createDBSubnetGroup)(request.buildAwsValue()).map(model.CreateDbSubnetGroupResponse.wrap).provide(r)
    def copyDBClusterParameterGroup(request: model.CopyDbClusterParameterGroupRequest): IO[AwsError, model.CopyDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest, software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupResponse]("copyDBClusterParameterGroup", api.copyDBClusterParameterGroup)(request.buildAwsValue()).map(model.CopyDbClusterParameterGroupResponse.wrap).provide(r)
    def describePendingMaintenanceActions(request: model.DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[Any, AwsError, model.ResourcePendingMaintenanceActions.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest, software.amazon.awssdk.services.docdb.model.ResourcePendingMaintenanceActions, software.amazon.awssdk.services.docdb.paginators.DescribePendingMaintenanceActionsPublisher]("describePendingMaintenanceActions", api.describePendingMaintenanceActionsPaginator, _.pendingMaintenanceActions())(request.buildAwsValue()).map(item => model.ResourcePendingMaintenanceActions.wrap(item)).provide(r)
    def deleteDBClusterParameterGroup(request: model.DeleteDbClusterParameterGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest, software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupResponse]("deleteDBClusterParameterGroup", api.deleteDBClusterParameterGroup)(request.buildAwsValue()).unit.provide(r)
    def removeFromGlobalCluster(request: model.RemoveFromGlobalClusterRequest): IO[AwsError, model.RemoveFromGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest, software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterResponse]("removeFromGlobalCluster", api.removeFromGlobalCluster)(request.buildAwsValue()).map(model.RemoveFromGlobalClusterResponse.wrap).provide(r)
    def modifyDBClusterParameterGroup(request: model.ModifyDbClusterParameterGroupRequest): IO[AwsError, model.ModifyDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest, software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupResponse]("modifyDBClusterParameterGroup", api.modifyDBClusterParameterGroup)(request.buildAwsValue()).map(model.ModifyDbClusterParameterGroupResponse.wrap).provide(r)
    def stopDBCluster(request: model.StopDbClusterRequest): IO[AwsError, model.StopDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.StopDbClusterRequest, software.amazon.awssdk.services.docdb.model.StopDbClusterResponse]("stopDBCluster", api.stopDBCluster)(request.buildAwsValue()).map(model.StopDbClusterResponse.wrap).provide(r)
    def createDBCluster(request: model.CreateDbClusterRequest): IO[AwsError, model.CreateDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest, software.amazon.awssdk.services.docdb.model.CreateDbClusterResponse]("createDBCluster", api.createDBCluster)(request.buildAwsValue()).map(model.CreateDbClusterResponse.wrap).provide(r)
    def describeCertificates(request: model.DescribeCertificatesRequest): zio.stream.ZStream[Any, AwsError, model.Certificate.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest, software.amazon.awssdk.services.docdb.model.Certificate, software.amazon.awssdk.services.docdb.paginators.DescribeCertificatesPublisher]("describeCertificates", api.describeCertificatesPaginator, _.certificates())(request.buildAwsValue()).map(item => model.Certificate.wrap(item)).provide(r)
    def deleteEventSubscription(request: model.DeleteEventSubscriptionRequest): IO[AwsError, model.DeleteEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest, software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionResponse]("deleteEventSubscription", api.deleteEventSubscription)(request.buildAwsValue()).map(model.DeleteEventSubscriptionResponse.wrap).provide(r)
    def describeDBSubnetGroups(request: model.DescribeDbSubnetGroupsRequest): zio.stream.ZStream[Any, AwsError, model.DBSubnetGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest, software.amazon.awssdk.services.docdb.model.DBSubnetGroup, software.amazon.awssdk.services.docdb.paginators.DescribeDBSubnetGroupsPublisher]("describeDBSubnetGroups", api.describeDBSubnetGroupsPaginator, _.dbSubnetGroups())(request.buildAwsValue()).map(item => model.DBSubnetGroup.wrap(item)).provide(r)
    def createDBClusterParameterGroup(request: model.CreateDbClusterParameterGroupRequest): IO[AwsError, model.CreateDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest, software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupResponse]("createDBClusterParameterGroup", api.createDBClusterParameterGroup)(request.buildAwsValue()).map(model.CreateDbClusterParameterGroupResponse.wrap).provide(r)
    def modifyDBCluster(request: model.ModifyDbClusterRequest): IO[AwsError, model.ModifyDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest, software.amazon.awssdk.services.docdb.model.ModifyDbClusterResponse]("modifyDBCluster", api.modifyDBCluster)(request.buildAwsValue()).map(model.ModifyDbClusterResponse.wrap).provide(r)
    def removeTagsFromResource(request: model.RemoveTagsFromResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest, software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceResponse]("removeTagsFromResource", api.removeTagsFromResource)(request.buildAwsValue()).unit.provide(r)
    def applyPendingMaintenanceAction(request: model.ApplyPendingMaintenanceActionRequest): IO[AwsError, model.ApplyPendingMaintenanceActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest, software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionResponse]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(request.buildAwsValue()).map(model.ApplyPendingMaintenanceActionResponse.wrap).provide(r)
    def modifyDBSubnetGroup(request: model.ModifyDbSubnetGroupRequest): IO[AwsError, model.ModifyDbSubnetGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest, software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupResponse]("modifyDBSubnetGroup", api.modifyDBSubnetGroup)(request.buildAwsValue()).map(model.ModifyDbSubnetGroupResponse.wrap).provide(r)
    def modifyGlobalCluster(request: model.ModifyGlobalClusterRequest): IO[AwsError, model.ModifyGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest, software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterResponse]("modifyGlobalCluster", api.modifyGlobalCluster)(request.buildAwsValue()).map(model.ModifyGlobalClusterResponse.wrap).provide(r)
    def restoreDBClusterFromSnapshot(request: model.RestoreDbClusterFromSnapshotRequest): IO[AwsError, model.RestoreDbClusterFromSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest, software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotResponse]("restoreDBClusterFromSnapshot", api.restoreDBClusterFromSnapshot)(request.buildAwsValue()).map(model.RestoreDbClusterFromSnapshotResponse.wrap).provide(r)
    def describeGlobalClusters(request: model.DescribeGlobalClustersRequest): zio.stream.ZStream[Any, AwsError, model.GlobalCluster.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest, software.amazon.awssdk.services.docdb.model.GlobalCluster, software.amazon.awssdk.services.docdb.paginators.DescribeGlobalClustersPublisher]("describeGlobalClusters", api.describeGlobalClustersPaginator, _.globalClusters())(request.buildAwsValue()).map(item => model.GlobalCluster.wrap(item)).provide(r)
    def describeDBClusterParameters(request: model.DescribeDbClusterParametersRequest): zio.stream.ZStream[Any, AwsError, model.Parameter.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest, software.amazon.awssdk.services.docdb.model.Parameter, software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterParametersPublisher]("describeDBClusterParameters", api.describeDBClusterParametersPaginator, _.parameters())(request.buildAwsValue()).map(item => model.Parameter.wrap(item)).provide(r)
    def modifyEventSubscription(request: model.ModifyEventSubscriptionRequest): IO[AwsError, model.ModifyEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest, software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionResponse]("modifyEventSubscription", api.modifyEventSubscription)(request.buildAwsValue()).map(model.ModifyEventSubscriptionResponse.wrap).provide(r)
    def createDBInstance(request: model.CreateDbInstanceRequest): IO[AwsError, model.CreateDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest, software.amazon.awssdk.services.docdb.model.CreateDbInstanceResponse]("createDBInstance", api.createDBInstance)(request.buildAwsValue()).map(model.CreateDbInstanceResponse.wrap).provide(r)
    def deleteDBClusterSnapshot(request: model.DeleteDbClusterSnapshotRequest): IO[AwsError, model.DeleteDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest, software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotResponse]("deleteDBClusterSnapshot", api.deleteDBClusterSnapshot)(request.buildAwsValue()).map(model.DeleteDbClusterSnapshotResponse.wrap).provide(r)
    def startDBCluster(request: model.StartDbClusterRequest): IO[AwsError, model.StartDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.StartDbClusterRequest, software.amazon.awssdk.services.docdb.model.StartDbClusterResponse]("startDBCluster", api.startDBCluster)(request.buildAwsValue()).map(model.StartDbClusterResponse.wrap).provide(r)
    def modifyDBClusterSnapshotAttribute(request: model.ModifyDbClusterSnapshotAttributeRequest): IO[AwsError, model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest, software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeResponse]("modifyDBClusterSnapshotAttribute", api.modifyDBClusterSnapshotAttribute)(request.buildAwsValue()).map(model.ModifyDbClusterSnapshotAttributeResponse.wrap).provide(r)
    def describeEventCategories(request: model.DescribeEventCategoriesRequest): IO[AwsError, model.DescribeEventCategoriesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest, software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesResponse]("describeEventCategories", api.describeEventCategories)(request.buildAwsValue()).map(model.DescribeEventCategoriesResponse.wrap).provide(r)
    def deleteDBSubnetGroup(request: model.DeleteDbSubnetGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest, software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupResponse]("deleteDBSubnetGroup", api.deleteDBSubnetGroup)(request.buildAwsValue()).unit.provide(r)
    def rebootDBInstance(request: model.RebootDbInstanceRequest): IO[AwsError, model.RebootDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest, software.amazon.awssdk.services.docdb.model.RebootDbInstanceResponse]("rebootDBInstance", api.rebootDBInstance)(request.buildAwsValue()).map(model.RebootDbInstanceResponse.wrap).provide(r)
    def describeDBClusterParameterGroups(request: model.DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, model.DBClusterParameterGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest, software.amazon.awssdk.services.docdb.model.DBClusterParameterGroup, software.amazon.awssdk.services.docdb.paginators.DescribeDBClusterParameterGroupsPublisher]("describeDBClusterParameterGroups", api.describeDBClusterParameterGroupsPaginator, _.dbClusterParameterGroups())(request.buildAwsValue()).map(item => model.DBClusterParameterGroup.wrap(item)).provide(r)
    def createEventSubscription(request: model.CreateEventSubscriptionRequest): IO[AwsError, model.CreateEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest, software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionResponse]("createEventSubscription", api.createEventSubscription)(request.buildAwsValue()).map(model.CreateEventSubscriptionResponse.wrap).provide(r)
    def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest, software.amazon.awssdk.services.docdb.model.ListTagsForResourceResponse]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue()).map(model.ListTagsForResourceResponse.wrap).provide(r)
    def restoreDBClusterToPointInTime(request: model.RestoreDbClusterToPointInTimeRequest): IO[AwsError, model.RestoreDbClusterToPointInTimeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest, software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeResponse]("restoreDBClusterToPointInTime", api.restoreDBClusterToPointInTime)(request.buildAwsValue()).map(model.RestoreDbClusterToPointInTimeResponse.wrap).provide(r)
    def describeDBClusters(request: model.DescribeDbClustersRequest): zio.stream.ZStream[Any, AwsError, model.DBCluster.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest, software.amazon.awssdk.services.docdb.model.DBCluster, software.amazon.awssdk.services.docdb.paginators.DescribeDBClustersPublisher]("describeDBClusters", api.describeDBClustersPaginator, _.dbClusters())(request.buildAwsValue()).map(item => model.DBCluster.wrap(item)).provide(r)
    def failoverDBCluster(request: model.FailoverDbClusterRequest): IO[AwsError, model.FailoverDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest, software.amazon.awssdk.services.docdb.model.FailoverDbClusterResponse]("failoverDBCluster", api.failoverDBCluster)(request.buildAwsValue()).map(model.FailoverDbClusterResponse.wrap).provide(r)
    def describeEventSubscriptions(request: model.DescribeEventSubscriptionsRequest): zio.stream.ZStream[Any, AwsError, model.EventSubscription.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsRequest, software.amazon.awssdk.services.docdb.model.EventSubscription, software.amazon.awssdk.services.docdb.paginators.DescribeEventSubscriptionsPublisher]("describeEventSubscriptions", api.describeEventSubscriptionsPaginator, _.eventSubscriptionsList())(request.buildAwsValue()).map(item => model.EventSubscription.wrap(item)).provide(r)
    def describeDBInstances(request: model.DescribeDbInstancesRequest): zio.stream.ZStream[Any, AwsError, model.DBInstance.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest, software.amazon.awssdk.services.docdb.model.DBInstance, software.amazon.awssdk.services.docdb.paginators.DescribeDBInstancesPublisher]("describeDBInstances", api.describeDBInstancesPaginator, _.dbInstances())(request.buildAwsValue()).map(item => model.DBInstance.wrap(item)).provide(r)
    def createDBClusterSnapshot(request: model.CreateDbClusterSnapshotRequest): IO[AwsError, model.CreateDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest, software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotResponse]("createDBClusterSnapshot", api.createDBClusterSnapshot)(request.buildAwsValue()).map(model.CreateDbClusterSnapshotResponse.wrap).provide(r)
    def deleteDBCluster(request: model.DeleteDbClusterRequest): IO[AwsError, model.DeleteDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest, software.amazon.awssdk.services.docdb.model.DeleteDbClusterResponse]("deleteDBCluster", api.deleteDBCluster)(request.buildAwsValue()).map(model.DeleteDbClusterResponse.wrap).provide(r)
    def deleteGlobalCluster(request: model.DeleteGlobalClusterRequest): IO[AwsError, model.DeleteGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest, software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterResponse]("deleteGlobalCluster", api.deleteGlobalCluster)(request.buildAwsValue()).map(model.DeleteGlobalClusterResponse.wrap).provide(r)
    def deleteDBInstance(request: model.DeleteDbInstanceRequest): IO[AwsError, model.DeleteDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest, software.amazon.awssdk.services.docdb.model.DeleteDbInstanceResponse]("deleteDBInstance", api.deleteDBInstance)(request.buildAwsValue()).map(model.DeleteDbInstanceResponse.wrap).provide(r)
    def addSourceIdentifierToSubscription(request: model.AddSourceIdentifierToSubscriptionRequest): IO[AwsError, model.AddSourceIdentifierToSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest, software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionResponse]("addSourceIdentifierToSubscription", api.addSourceIdentifierToSubscription)(request.buildAwsValue()).map(model.AddSourceIdentifierToSubscriptionResponse.wrap).provide(r)
    def describeDBEngineVersions(request: model.DescribeDbEngineVersionsRequest): zio.stream.ZStream[Any, AwsError, model.DBEngineVersion.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest, software.amazon.awssdk.services.docdb.model.DBEngineVersion, software.amazon.awssdk.services.docdb.paginators.DescribeDBEngineVersionsPublisher]("describeDBEngineVersions", api.describeDBEngineVersionsPaginator, _.dbEngineVersions())(request.buildAwsValue()).map(item => model.DBEngineVersion.wrap(item)).provide(r)
    def createGlobalCluster(request: model.CreateGlobalClusterRequest): IO[AwsError, model.CreateGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest, software.amazon.awssdk.services.docdb.model.CreateGlobalClusterResponse]("createGlobalCluster", api.createGlobalCluster)(request.buildAwsValue()).map(model.CreateGlobalClusterResponse.wrap).provide(r)
    def describeOrderableDBInstanceOptions(request: model.DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[Any, AwsError, model.OrderableDBInstanceOption.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest, software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption, software.amazon.awssdk.services.docdb.paginators.DescribeOrderableDBInstanceOptionsPublisher]("describeOrderableDBInstanceOptions", api.describeOrderableDBInstanceOptionsPaginator, _.orderableDBInstanceOptions())(request.buildAwsValue()).map(item => model.OrderableDBInstanceOption.wrap(item)).provide(r)
    def describeDBClusterSnapshotAttributes(request: model.DescribeDbClusterSnapshotAttributesRequest): IO[AwsError, model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest, software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesResponse]("describeDBClusterSnapshotAttributes", api.describeDBClusterSnapshotAttributes)(request.buildAwsValue()).map(model.DescribeDbClusterSnapshotAttributesResponse.wrap).provide(r)
    def describeEvents(request: model.DescribeEventsRequest): zio.stream.ZStream[Any, AwsError, model.Event.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.docdb.model.DescribeEventsRequest, software.amazon.awssdk.services.docdb.model.Event, software.amazon.awssdk.services.docdb.paginators.DescribeEventsPublisher]("describeEvents", api.describeEventsPaginator, _.events())(request.buildAwsValue()).map(item => model.Event.wrap(item)).provide(r)
  }
  def copyDBClusterSnapshot(request: model.CopyDbClusterSnapshotRequest): ZIO[DocDb, AwsError, model.CopyDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.copyDBClusterSnapshot(request))
  def modifyDBInstance(request: model.ModifyDbInstanceRequest): ZIO[DocDb, AwsError, model.ModifyDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBInstance(request))
  def addTagsToResource(request: model.AddTagsToResourceRequest): ZIO[DocDb, AwsError, scala.Unit] = ZIO.accessM(_.get.addTagsToResource(request))
  def describeDBClusterSnapshots(request: model.DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[DocDb, AwsError, model.DBClusterSnapshot.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterSnapshots(request))
  def resetDBClusterParameterGroup(request: model.ResetDbClusterParameterGroupRequest): ZIO[DocDb, AwsError, model.ResetDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.resetDBClusterParameterGroup(request))
  def removeSourceIdentifierFromSubscription(request: model.RemoveSourceIdentifierFromSubscriptionRequest): ZIO[DocDb, AwsError, model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.removeSourceIdentifierFromSubscription(request))
  def describeEngineDefaultClusterParameters(request: model.DescribeEngineDefaultClusterParametersRequest): ZIO[DocDb, AwsError, model.DescribeEngineDefaultClusterParametersResponse.ReadOnly] = ZIO.accessM(_.get.describeEngineDefaultClusterParameters(request))
  def createDBSubnetGroup(request: model.CreateDbSubnetGroupRequest): ZIO[DocDb, AwsError, model.CreateDbSubnetGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBSubnetGroup(request))
  def copyDBClusterParameterGroup(request: model.CopyDbClusterParameterGroupRequest): ZIO[DocDb, AwsError, model.CopyDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.copyDBClusterParameterGroup(request))
  def describePendingMaintenanceActions(request: model.DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[DocDb, AwsError, model.ResourcePendingMaintenanceActions.ReadOnly] = ZStream.accessStream(_.get.describePendingMaintenanceActions(request))
  def deleteDBClusterParameterGroup(request: model.DeleteDbClusterParameterGroupRequest): ZIO[DocDb, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBClusterParameterGroup(request))
  def removeFromGlobalCluster(request: model.RemoveFromGlobalClusterRequest): ZIO[DocDb, AwsError, model.RemoveFromGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.removeFromGlobalCluster(request))
  def modifyDBClusterParameterGroup(request: model.ModifyDbClusterParameterGroupRequest): ZIO[DocDb, AwsError, model.ModifyDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBClusterParameterGroup(request))
  def stopDBCluster(request: model.StopDbClusterRequest): ZIO[DocDb, AwsError, model.StopDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.stopDBCluster(request))
  def createDBCluster(request: model.CreateDbClusterRequest): ZIO[DocDb, AwsError, model.CreateDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.createDBCluster(request))
  def describeCertificates(request: model.DescribeCertificatesRequest): zio.stream.ZStream[DocDb, AwsError, model.Certificate.ReadOnly] = ZStream.accessStream(_.get.describeCertificates(request))
  def deleteEventSubscription(request: model.DeleteEventSubscriptionRequest): ZIO[DocDb, AwsError, model.DeleteEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.deleteEventSubscription(request))
  def describeDBSubnetGroups(request: model.DescribeDbSubnetGroupsRequest): zio.stream.ZStream[DocDb, AwsError, model.DBSubnetGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBSubnetGroups(request))
  def createDBClusterParameterGroup(request: model.CreateDbClusterParameterGroupRequest): ZIO[DocDb, AwsError, model.CreateDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBClusterParameterGroup(request))
  def modifyDBCluster(request: model.ModifyDbClusterRequest): ZIO[DocDb, AwsError, model.ModifyDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBCluster(request))
  def removeTagsFromResource(request: model.RemoveTagsFromResourceRequest): ZIO[DocDb, AwsError, scala.Unit] = ZIO.accessM(_.get.removeTagsFromResource(request))
  def applyPendingMaintenanceAction(request: model.ApplyPendingMaintenanceActionRequest): ZIO[DocDb, AwsError, model.ApplyPendingMaintenanceActionResponse.ReadOnly] = ZIO.accessM(_.get.applyPendingMaintenanceAction(request))
  def modifyDBSubnetGroup(request: model.ModifyDbSubnetGroupRequest): ZIO[DocDb, AwsError, model.ModifyDbSubnetGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBSubnetGroup(request))
  def modifyGlobalCluster(request: model.ModifyGlobalClusterRequest): ZIO[DocDb, AwsError, model.ModifyGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.modifyGlobalCluster(request))
  def restoreDBClusterFromSnapshot(request: model.RestoreDbClusterFromSnapshotRequest): ZIO[DocDb, AwsError, model.RestoreDbClusterFromSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBClusterFromSnapshot(request))
  def describeGlobalClusters(request: model.DescribeGlobalClustersRequest): zio.stream.ZStream[DocDb, AwsError, model.GlobalCluster.ReadOnly] = ZStream.accessStream(_.get.describeGlobalClusters(request))
  def describeDBClusterParameters(request: model.DescribeDbClusterParametersRequest): zio.stream.ZStream[DocDb, AwsError, model.Parameter.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterParameters(request))
  def modifyEventSubscription(request: model.ModifyEventSubscriptionRequest): ZIO[DocDb, AwsError, model.ModifyEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.modifyEventSubscription(request))
  def createDBInstance(request: model.CreateDbInstanceRequest): ZIO[DocDb, AwsError, model.CreateDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.createDBInstance(request))
  def deleteDBClusterSnapshot(request: model.DeleteDbClusterSnapshotRequest): ZIO[DocDb, AwsError, model.DeleteDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBClusterSnapshot(request))
  def startDBCluster(request: model.StartDbClusterRequest): ZIO[DocDb, AwsError, model.StartDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.startDBCluster(request))
  def modifyDBClusterSnapshotAttribute(request: model.ModifyDbClusterSnapshotAttributeRequest): ZIO[DocDb, AwsError, model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBClusterSnapshotAttribute(request))
  def describeEventCategories(request: model.DescribeEventCategoriesRequest): ZIO[DocDb, AwsError, model.DescribeEventCategoriesResponse.ReadOnly] = ZIO.accessM(_.get.describeEventCategories(request))
  def deleteDBSubnetGroup(request: model.DeleteDbSubnetGroupRequest): ZIO[DocDb, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBSubnetGroup(request))
  def rebootDBInstance(request: model.RebootDbInstanceRequest): ZIO[DocDb, AwsError, model.RebootDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.rebootDBInstance(request))
  def describeDBClusterParameterGroups(request: model.DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[DocDb, AwsError, model.DBClusterParameterGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterParameterGroups(request))
  def createEventSubscription(request: model.CreateEventSubscriptionRequest): ZIO[DocDb, AwsError, model.CreateEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.createEventSubscription(request))
  def listTagsForResource(request: model.ListTagsForResourceRequest): ZIO[DocDb, AwsError, model.ListTagsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.listTagsForResource(request))
  def restoreDBClusterToPointInTime(request: model.RestoreDbClusterToPointInTimeRequest): ZIO[DocDb, AwsError, model.RestoreDbClusterToPointInTimeResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBClusterToPointInTime(request))
  def describeDBClusters(request: model.DescribeDbClustersRequest): zio.stream.ZStream[DocDb, AwsError, model.DBCluster.ReadOnly] = ZStream.accessStream(_.get.describeDBClusters(request))
  def failoverDBCluster(request: model.FailoverDbClusterRequest): ZIO[DocDb, AwsError, model.FailoverDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.failoverDBCluster(request))
  def describeEventSubscriptions(request: model.DescribeEventSubscriptionsRequest): zio.stream.ZStream[DocDb, AwsError, model.EventSubscription.ReadOnly] = ZStream.accessStream(_.get.describeEventSubscriptions(request))
  def describeDBInstances(request: model.DescribeDbInstancesRequest): zio.stream.ZStream[DocDb, AwsError, model.DBInstance.ReadOnly] = ZStream.accessStream(_.get.describeDBInstances(request))
  def createDBClusterSnapshot(request: model.CreateDbClusterSnapshotRequest): ZIO[DocDb, AwsError, model.CreateDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createDBClusterSnapshot(request))
  def deleteDBCluster(request: model.DeleteDbClusterRequest): ZIO[DocDb, AwsError, model.DeleteDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBCluster(request))
  def deleteGlobalCluster(request: model.DeleteGlobalClusterRequest): ZIO[DocDb, AwsError, model.DeleteGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.deleteGlobalCluster(request))
  def deleteDBInstance(request: model.DeleteDbInstanceRequest): ZIO[DocDb, AwsError, model.DeleteDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBInstance(request))
  def addSourceIdentifierToSubscription(request: model.AddSourceIdentifierToSubscriptionRequest): ZIO[DocDb, AwsError, model.AddSourceIdentifierToSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.addSourceIdentifierToSubscription(request))
  def describeDBEngineVersions(request: model.DescribeDbEngineVersionsRequest): zio.stream.ZStream[DocDb, AwsError, model.DBEngineVersion.ReadOnly] = ZStream.accessStream(_.get.describeDBEngineVersions(request))
  def createGlobalCluster(request: model.CreateGlobalClusterRequest): ZIO[DocDb, AwsError, model.CreateGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.createGlobalCluster(request))
  def describeOrderableDBInstanceOptions(request: model.DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[DocDb, AwsError, model.OrderableDBInstanceOption.ReadOnly] = ZStream.accessStream(_.get.describeOrderableDBInstanceOptions(request))
  def describeDBClusterSnapshotAttributes(request: model.DescribeDbClusterSnapshotAttributesRequest): ZIO[DocDb, AwsError, model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly] = ZIO.accessM(_.get.describeDBClusterSnapshotAttributes(request))
  def describeEvents(request: model.DescribeEventsRequest): zio.stream.ZStream[DocDb, AwsError, model.Event.ReadOnly] = ZStream.accessStream(_.get.describeEvents(request))
}