package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddApplicationCloudWatchLoggingOptionRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, cloudWatchLoggingOption: CloudWatchLoggingOption) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest = {
    import AddApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).cloudWatchLoggingOption(cloudWatchLoggingOption.buildAwsValue()).build()
  }
  def asReadOnly: AddApplicationCloudWatchLoggingOptionRequest.ReadOnly = AddApplicationCloudWatchLoggingOptionRequest.wrap(buildAwsValue())
}
object AddApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddApplicationCloudWatchLoggingOptionRequest = AddApplicationCloudWatchLoggingOptionRequest(applicationNameValue, currentApplicationVersionIdValue, cloudWatchLoggingOptionValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def cloudWatchLoggingOptionValue: CloudWatchLoggingOption.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def cloudWatchLoggingOption: ZIO[Any, Nothing, CloudWatchLoggingOption.ReadOnly] = ZIO.succeed(cloudWatchLoggingOptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest) extends AddApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def cloudWatchLoggingOptionValue: CloudWatchLoggingOption.ReadOnly = CloudWatchLoggingOption.wrap(impl.cloudWatchLoggingOption())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest): ReadOnly = new Wrapper(impl)
}