package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddApplicationInputProcessingConfigurationRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, inputId: primitives.Id, inputProcessingConfiguration: InputProcessingConfiguration) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest = {
    import AddApplicationInputProcessingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).inputId(inputId: java.lang.String).inputProcessingConfiguration(inputProcessingConfiguration.buildAwsValue()).build()
  }
  def asReadOnly: AddApplicationInputProcessingConfigurationRequest.ReadOnly = AddApplicationInputProcessingConfigurationRequest.wrap(buildAwsValue())
}
object AddApplicationInputProcessingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddApplicationInputProcessingConfigurationRequest = AddApplicationInputProcessingConfigurationRequest(applicationNameValue, currentApplicationVersionIdValue, inputIdValue, inputProcessingConfigurationValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def inputIdValue: primitives.Id
    def inputProcessingConfigurationValue: InputProcessingConfiguration.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def inputId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(inputIdValue)
    def inputProcessingConfiguration: ZIO[Any, Nothing, InputProcessingConfiguration.ReadOnly] = ZIO.succeed(inputProcessingConfigurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest) extends AddApplicationInputProcessingConfigurationRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def inputIdValue: primitives.Id = impl.inputId(): primitives.Id
    override def inputProcessingConfigurationValue: InputProcessingConfiguration.ReadOnly = InputProcessingConfiguration.wrap(impl.inputProcessingConfiguration())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest): ReadOnly = new Wrapper(impl)
}