package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddApplicationInputRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, input: Input) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest = {
    import AddApplicationInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).input(input.buildAwsValue()).build()
  }
  def asReadOnly: AddApplicationInputRequest.ReadOnly = AddApplicationInputRequest.wrap(buildAwsValue())
}
object AddApplicationInputRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddApplicationInputRequest = AddApplicationInputRequest(applicationNameValue, currentApplicationVersionIdValue, inputValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def inputValue: Input.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def input: ZIO[Any, Nothing, Input.ReadOnly] = ZIO.succeed(inputValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest) extends AddApplicationInputRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def inputValue: Input.ReadOnly = Input.wrap(impl.input())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest): ReadOnly = new Wrapper(impl)
}