package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddApplicationOutputRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, output: Output) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest = {
    import AddApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).output(output.buildAwsValue()).build()
  }
  def asReadOnly: AddApplicationOutputRequest.ReadOnly = AddApplicationOutputRequest.wrap(buildAwsValue())
}
object AddApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddApplicationOutputRequest = AddApplicationOutputRequest(applicationNameValue, currentApplicationVersionIdValue, outputValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def outputValue: Output.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def output: ZIO[Any, Nothing, Output.ReadOnly] = ZIO.succeed(outputValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest) extends AddApplicationOutputRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def outputValue: Output.ReadOnly = Output.wrap(impl.output())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest): ReadOnly = new Wrapper(impl)
}