package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AddApplicationReferenceDataSourceRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, referenceDataSource: ReferenceDataSource) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest = {
    import AddApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).referenceDataSource(referenceDataSource.buildAwsValue()).build()
  }
  def asReadOnly: AddApplicationReferenceDataSourceRequest.ReadOnly = AddApplicationReferenceDataSourceRequest.wrap(buildAwsValue())
}
object AddApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AddApplicationReferenceDataSourceRequest = AddApplicationReferenceDataSourceRequest(applicationNameValue, currentApplicationVersionIdValue, referenceDataSourceValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def referenceDataSourceValue: ReferenceDataSource.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def referenceDataSource: ZIO[Any, Nothing, ReferenceDataSource.ReadOnly] = ZIO.succeed(referenceDataSourceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest) extends AddApplicationReferenceDataSourceRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def referenceDataSourceValue: ReferenceDataSource.ReadOnly = ReferenceDataSource.wrap(impl.referenceDataSource())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest): ReadOnly = new Wrapper(impl)
}