package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ApplicationDetail(applicationName: primitives.ApplicationName, applicationDescription: scala.Option[primitives.ApplicationDescription] = None, applicationARN: primitives.ResourceARN, applicationStatus: ApplicationStatus, createTimestamp: scala.Option[primitives.Timestamp] = None, lastUpdateTimestamp: scala.Option[primitives.Timestamp] = None, inputDescriptions: scala.Option[Iterable[InputDescription]] = None, outputDescriptions: scala.Option[Iterable[OutputDescription]] = None, referenceDataSourceDescriptions: scala.Option[Iterable[ReferenceDataSourceDescription]] = None, cloudWatchLoggingOptionDescriptions: scala.Option[Iterable[CloudWatchLoggingOptionDescription]] = None, applicationCode: scala.Option[primitives.ApplicationCode] = None, applicationVersionId: primitives.ApplicationVersionId) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail = {
    import ApplicationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail.builder().applicationName(applicationName: java.lang.String).optionallyWith(applicationDescription.map(value => value: java.lang.String))(_.applicationDescription).applicationARN(applicationARN: java.lang.String).applicationStatus(applicationStatus.unwrap).optionallyWith(createTimestamp.map(value => value: java.time.Instant))(_.createTimestamp).optionallyWith(lastUpdateTimestamp.map(value => value: java.time.Instant))(_.lastUpdateTimestamp).optionallyWith(inputDescriptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.inputDescriptions).optionallyWith(outputDescriptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.outputDescriptions).optionallyWith(referenceDataSourceDescriptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.referenceDataSourceDescriptions).optionallyWith(cloudWatchLoggingOptionDescriptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cloudWatchLoggingOptionDescriptions).optionallyWith(applicationCode.map(value => value: java.lang.String))(_.applicationCode).applicationVersionId(applicationVersionId: java.lang.Long).build()
  }
  def asReadOnly: ApplicationDetail.ReadOnly = ApplicationDetail.wrap(buildAwsValue())
}
object ApplicationDetail {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ApplicationDetail = ApplicationDetail(applicationNameValue, applicationDescriptionValue.map(value => value), applicationARNValue, applicationStatusValue, createTimestampValue.map(value => value), lastUpdateTimestampValue.map(value => value), inputDescriptionsValue.map(value => value.map { item => 
      item.editable
    }), outputDescriptionsValue.map(value => value.map { item => 
      item.editable
    }), referenceDataSourceDescriptionsValue.map(value => value.map { item => 
      item.editable
    }), cloudWatchLoggingOptionDescriptionsValue.map(value => value.map { item => 
      item.editable
    }), applicationCodeValue.map(value => value), applicationVersionIdValue)
    def applicationNameValue: primitives.ApplicationName
    def applicationDescriptionValue: scala.Option[primitives.ApplicationDescription]
    def applicationARNValue: primitives.ResourceARN
    def applicationStatusValue: ApplicationStatus
    def createTimestampValue: scala.Option[primitives.Timestamp]
    def lastUpdateTimestampValue: scala.Option[primitives.Timestamp]
    def inputDescriptionsValue: scala.Option[List[InputDescription.ReadOnly]]
    def outputDescriptionsValue: scala.Option[List[OutputDescription.ReadOnly]]
    def referenceDataSourceDescriptionsValue: scala.Option[List[ReferenceDataSourceDescription.ReadOnly]]
    def cloudWatchLoggingOptionDescriptionsValue: scala.Option[List[CloudWatchLoggingOptionDescription.ReadOnly]]
    def applicationCodeValue: scala.Option[primitives.ApplicationCode]
    def applicationVersionIdValue: primitives.ApplicationVersionId
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def applicationDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applicationDescription", applicationDescriptionValue)
    def applicationARN: ZIO[Any, Nothing, primitives.ResourceARN] = ZIO.succeed(applicationARNValue)
    def applicationStatus: ZIO[Any, Nothing, ApplicationStatus] = ZIO.succeed(applicationStatusValue)
    def createTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createTimestamp", createTimestampValue)
    def lastUpdateTimestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestampValue)
    def inputDescriptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InputDescription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputDescriptions", inputDescriptionsValue)
    def outputDescriptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OutputDescription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("outputDescriptions", outputDescriptionsValue)
    def referenceDataSourceDescriptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReferenceDataSourceDescription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("referenceDataSourceDescriptions", referenceDataSourceDescriptionsValue)
    def cloudWatchLoggingOptionDescriptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CloudWatchLoggingOptionDescription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudWatchLoggingOptionDescriptions", cloudWatchLoggingOptionDescriptionsValue)
    def applicationCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applicationCode", applicationCodeValue)
    def applicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(applicationVersionIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail) extends ApplicationDetail.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def applicationDescriptionValue: scala.Option[primitives.ApplicationDescription] = scala.Option(impl.applicationDescription()).map(value => value: primitives.ApplicationDescription)
    override def applicationARNValue: primitives.ResourceARN = impl.applicationARN(): primitives.ResourceARN
    override def applicationStatusValue: ApplicationStatus = ApplicationStatus.wrap(impl.applicationStatus())
    override def createTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.createTimestamp()).map(value => value: primitives.Timestamp)
    override def lastUpdateTimestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.lastUpdateTimestamp()).map(value => value: primitives.Timestamp)
    override def inputDescriptionsValue: scala.Option[List[InputDescription.ReadOnly]] = scala.Option(impl.inputDescriptions()).map(value => value.asScala.map { item => 
      InputDescription.wrap(item)
    }.toList)
    override def outputDescriptionsValue: scala.Option[List[OutputDescription.ReadOnly]] = scala.Option(impl.outputDescriptions()).map(value => value.asScala.map { item => 
      OutputDescription.wrap(item)
    }.toList)
    override def referenceDataSourceDescriptionsValue: scala.Option[List[ReferenceDataSourceDescription.ReadOnly]] = scala.Option(impl.referenceDataSourceDescriptions()).map(value => value.asScala.map { item => 
      ReferenceDataSourceDescription.wrap(item)
    }.toList)
    override def cloudWatchLoggingOptionDescriptionsValue: scala.Option[List[CloudWatchLoggingOptionDescription.ReadOnly]] = scala.Option(impl.cloudWatchLoggingOptionDescriptions()).map(value => value.asScala.map { item => 
      CloudWatchLoggingOptionDescription.wrap(item)
    }.toList)
    override def applicationCodeValue: scala.Option[primitives.ApplicationCode] = scala.Option(impl.applicationCode()).map(value => value: primitives.ApplicationCode)
    override def applicationVersionIdValue: primitives.ApplicationVersionId = impl.applicationVersionId(): primitives.ApplicationVersionId
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationDetail): ReadOnly = new Wrapper(impl)
}