package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ApplicationStatus { def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus }
object ApplicationStatus {
  def wrap(value: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus): ApplicationStatus = value match {
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UNKNOWN_TO_SDK_VERSION }
  case object DELETING extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.DELETING }
  case object STARTING extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STARTING }
  case object STOPPING extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.STOPPING }
  case object READY extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.READY }
  case object RUNNING extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.RUNNING }
  case object UPDATING extends ApplicationStatus { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus = software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus.UPDATING }
}