package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ApplicationSummary(applicationName: primitives.ApplicationName, applicationARN: primitives.ResourceARN, applicationStatus: ApplicationStatus) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary.builder().applicationName(applicationName: java.lang.String).applicationARN(applicationARN: java.lang.String).applicationStatus(applicationStatus.unwrap).build()
  }
  def asReadOnly: ApplicationSummary.ReadOnly = ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ApplicationSummary = ApplicationSummary(applicationNameValue, applicationARNValue, applicationStatusValue)
    def applicationNameValue: primitives.ApplicationName
    def applicationARNValue: primitives.ResourceARN
    def applicationStatusValue: ApplicationStatus
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def applicationARN: ZIO[Any, Nothing, primitives.ResourceARN] = ZIO.succeed(applicationARNValue)
    def applicationStatus: ZIO[Any, Nothing, ApplicationStatus] = ZIO.succeed(applicationStatusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary) extends ApplicationSummary.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def applicationARNValue: primitives.ResourceARN = impl.applicationARN(): primitives.ResourceARN
    override def applicationStatusValue: ApplicationStatus = ApplicationStatus.wrap(impl.applicationStatus())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationSummary): ReadOnly = new Wrapper(impl)
}