package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ApplicationUpdate(inputUpdates: scala.Option[Iterable[InputUpdate]] = None, applicationCodeUpdate: scala.Option[primitives.ApplicationCode] = None, outputUpdates: scala.Option[Iterable[OutputUpdate]] = None, referenceDataSourceUpdates: scala.Option[Iterable[ReferenceDataSourceUpdate]] = None, cloudWatchLoggingOptionUpdates: scala.Option[Iterable[CloudWatchLoggingOptionUpdate]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate = {
    import ApplicationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate.builder().optionallyWith(inputUpdates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.inputUpdates).optionallyWith(applicationCodeUpdate.map(value => value: java.lang.String))(_.applicationCodeUpdate).optionallyWith(outputUpdates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.outputUpdates).optionallyWith(referenceDataSourceUpdates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.referenceDataSourceUpdates).optionallyWith(cloudWatchLoggingOptionUpdates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cloudWatchLoggingOptionUpdates).build()
  }
  def asReadOnly: ApplicationUpdate.ReadOnly = ApplicationUpdate.wrap(buildAwsValue())
}
object ApplicationUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ApplicationUpdate = ApplicationUpdate(inputUpdatesValue.map(value => value.map { item => 
      item.editable
    }), applicationCodeUpdateValue.map(value => value), outputUpdatesValue.map(value => value.map { item => 
      item.editable
    }), referenceDataSourceUpdatesValue.map(value => value.map { item => 
      item.editable
    }), cloudWatchLoggingOptionUpdatesValue.map(value => value.map { item => 
      item.editable
    }))
    def inputUpdatesValue: scala.Option[List[InputUpdate.ReadOnly]]
    def applicationCodeUpdateValue: scala.Option[primitives.ApplicationCode]
    def outputUpdatesValue: scala.Option[List[OutputUpdate.ReadOnly]]
    def referenceDataSourceUpdatesValue: scala.Option[List[ReferenceDataSourceUpdate.ReadOnly]]
    def cloudWatchLoggingOptionUpdatesValue: scala.Option[List[CloudWatchLoggingOptionUpdate.ReadOnly]]
    def inputUpdates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InputUpdate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputUpdates", inputUpdatesValue)
    def applicationCodeUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applicationCodeUpdate", applicationCodeUpdateValue)
    def outputUpdates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OutputUpdate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("outputUpdates", outputUpdatesValue)
    def referenceDataSourceUpdates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReferenceDataSourceUpdate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("referenceDataSourceUpdates", referenceDataSourceUpdatesValue)
    def cloudWatchLoggingOptionUpdates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CloudWatchLoggingOptionUpdate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudWatchLoggingOptionUpdates", cloudWatchLoggingOptionUpdatesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate) extends ApplicationUpdate.ReadOnly {
    override def inputUpdatesValue: scala.Option[List[InputUpdate.ReadOnly]] = scala.Option(impl.inputUpdates()).map(value => value.asScala.map { item => 
      InputUpdate.wrap(item)
    }.toList)
    override def applicationCodeUpdateValue: scala.Option[primitives.ApplicationCode] = scala.Option(impl.applicationCodeUpdate()).map(value => value: primitives.ApplicationCode)
    override def outputUpdatesValue: scala.Option[List[OutputUpdate.ReadOnly]] = scala.Option(impl.outputUpdates()).map(value => value.asScala.map { item => 
      OutputUpdate.wrap(item)
    }.toList)
    override def referenceDataSourceUpdatesValue: scala.Option[List[ReferenceDataSourceUpdate.ReadOnly]] = scala.Option(impl.referenceDataSourceUpdates()).map(value => value.asScala.map { item => 
      ReferenceDataSourceUpdate.wrap(item)
    }.toList)
    override def cloudWatchLoggingOptionUpdatesValue: scala.Option[List[CloudWatchLoggingOptionUpdate.ReadOnly]] = scala.Option(impl.cloudWatchLoggingOptionUpdates()).map(value => value.asScala.map { item => 
      CloudWatchLoggingOptionUpdate.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate): ReadOnly = new Wrapper(impl)
}