package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CSVMappingParameters(recordRowDelimiter: primitives.RecordRowDelimiter, recordColumnDelimiter: primitives.RecordColumnDelimiter) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters = {
    import CSVMappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters.builder().recordRowDelimiter(recordRowDelimiter: java.lang.String).recordColumnDelimiter(recordColumnDelimiter: java.lang.String).build()
  }
  def asReadOnly: CSVMappingParameters.ReadOnly = CSVMappingParameters.wrap(buildAwsValue())
}
object CSVMappingParameters {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CSVMappingParameters = CSVMappingParameters(recordRowDelimiterValue, recordColumnDelimiterValue)
    def recordRowDelimiterValue: primitives.RecordRowDelimiter
    def recordColumnDelimiterValue: primitives.RecordColumnDelimiter
    def recordRowDelimiter: ZIO[Any, Nothing, primitives.RecordRowDelimiter] = ZIO.succeed(recordRowDelimiterValue)
    def recordColumnDelimiter: ZIO[Any, Nothing, primitives.RecordColumnDelimiter] = ZIO.succeed(recordColumnDelimiterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters) extends CSVMappingParameters.ReadOnly {
    override def recordRowDelimiterValue: primitives.RecordRowDelimiter = impl.recordRowDelimiter(): primitives.RecordRowDelimiter
    override def recordColumnDelimiterValue: primitives.RecordColumnDelimiter = impl.recordColumnDelimiter(): primitives.RecordColumnDelimiter
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CSVMappingParameters): ReadOnly = new Wrapper(impl)
}