package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloudWatchLoggingOption(logStreamARN: primitives.LogStreamARN, roleARN: primitives.RoleARN) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption = {
    import CloudWatchLoggingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption.builder().logStreamARN(logStreamARN: java.lang.String).roleARN(roleARN: java.lang.String).build()
  }
  def asReadOnly: CloudWatchLoggingOption.ReadOnly = CloudWatchLoggingOption.wrap(buildAwsValue())
}
object CloudWatchLoggingOption {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloudWatchLoggingOption = CloudWatchLoggingOption(logStreamARNValue, roleARNValue)
    def logStreamARNValue: primitives.LogStreamARN
    def roleARNValue: primitives.RoleARN
    def logStreamARN: ZIO[Any, Nothing, primitives.LogStreamARN] = ZIO.succeed(logStreamARNValue)
    def roleARN: ZIO[Any, Nothing, primitives.RoleARN] = ZIO.succeed(roleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption) extends CloudWatchLoggingOption.ReadOnly {
    override def logStreamARNValue: primitives.LogStreamARN = impl.logStreamARN(): primitives.LogStreamARN
    override def roleARNValue: primitives.RoleARN = impl.roleARN(): primitives.RoleARN
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOption): ReadOnly = new Wrapper(impl)
}