package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloudWatchLoggingOptionDescription(cloudWatchLoggingOptionId: scala.Option[primitives.Id] = None, logStreamARN: primitives.LogStreamARN, roleARN: primitives.RoleARN) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription = {
    import CloudWatchLoggingOptionDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription.builder().optionallyWith(cloudWatchLoggingOptionId.map(value => value: java.lang.String))(_.cloudWatchLoggingOptionId).logStreamARN(logStreamARN: java.lang.String).roleARN(roleARN: java.lang.String).build()
  }
  def asReadOnly: CloudWatchLoggingOptionDescription.ReadOnly = CloudWatchLoggingOptionDescription.wrap(buildAwsValue())
}
object CloudWatchLoggingOptionDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloudWatchLoggingOptionDescription = CloudWatchLoggingOptionDescription(cloudWatchLoggingOptionIdValue.map(value => value), logStreamARNValue, roleARNValue)
    def cloudWatchLoggingOptionIdValue: scala.Option[primitives.Id]
    def logStreamARNValue: primitives.LogStreamARN
    def roleARNValue: primitives.RoleARN
    def cloudWatchLoggingOptionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Id] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudWatchLoggingOptionId", cloudWatchLoggingOptionIdValue)
    def logStreamARN: ZIO[Any, Nothing, primitives.LogStreamARN] = ZIO.succeed(logStreamARNValue)
    def roleARN: ZIO[Any, Nothing, primitives.RoleARN] = ZIO.succeed(roleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription) extends CloudWatchLoggingOptionDescription.ReadOnly {
    override def cloudWatchLoggingOptionIdValue: scala.Option[primitives.Id] = scala.Option(impl.cloudWatchLoggingOptionId()).map(value => value: primitives.Id)
    override def logStreamARNValue: primitives.LogStreamARN = impl.logStreamARN(): primitives.LogStreamARN
    override def roleARNValue: primitives.RoleARN = impl.roleARN(): primitives.RoleARN
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionDescription): ReadOnly = new Wrapper(impl)
}