package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloudWatchLoggingOptionUpdate(cloudWatchLoggingOptionId: primitives.Id, logStreamARNUpdate: scala.Option[primitives.LogStreamARN] = None, roleARNUpdate: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate = {
    import CloudWatchLoggingOptionUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate.builder().cloudWatchLoggingOptionId(cloudWatchLoggingOptionId: java.lang.String).optionallyWith(logStreamARNUpdate.map(value => value: java.lang.String))(_.logStreamARNUpdate).optionallyWith(roleARNUpdate.map(value => value: java.lang.String))(_.roleARNUpdate).build()
  }
  def asReadOnly: CloudWatchLoggingOptionUpdate.ReadOnly = CloudWatchLoggingOptionUpdate.wrap(buildAwsValue())
}
object CloudWatchLoggingOptionUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloudWatchLoggingOptionUpdate = CloudWatchLoggingOptionUpdate(cloudWatchLoggingOptionIdValue, logStreamARNUpdateValue.map(value => value), roleARNUpdateValue.map(value => value))
    def cloudWatchLoggingOptionIdValue: primitives.Id
    def logStreamARNUpdateValue: scala.Option[primitives.LogStreamARN]
    def roleARNUpdateValue: scala.Option[primitives.RoleARN]
    def cloudWatchLoggingOptionId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(cloudWatchLoggingOptionIdValue)
    def logStreamARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LogStreamARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logStreamARNUpdate", logStreamARNUpdateValue)
    def roleARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate) extends CloudWatchLoggingOptionUpdate.ReadOnly {
    override def cloudWatchLoggingOptionIdValue: primitives.Id = impl.cloudWatchLoggingOptionId(): primitives.Id
    override def logStreamARNUpdateValue: scala.Option[primitives.LogStreamARN] = scala.Option(impl.logStreamARNUpdate()).map(value => value: primitives.LogStreamARN)
    override def roleARNUpdateValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARNUpdate()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CloudWatchLoggingOptionUpdate): ReadOnly = new Wrapper(impl)
}