package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateApplicationRequest(applicationName: primitives.ApplicationName, applicationDescription: scala.Option[primitives.ApplicationDescription] = None, inputs: scala.Option[Iterable[Input]] = None, outputs: scala.Option[Iterable[Output]] = None, cloudWatchLoggingOptions: scala.Option[Iterable[CloudWatchLoggingOption]] = None, applicationCode: scala.Option[primitives.ApplicationCode] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest.builder().applicationName(applicationName: java.lang.String).optionallyWith(applicationDescription.map(value => value: java.lang.String))(_.applicationDescription).optionallyWith(inputs.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.inputs).optionallyWith(outputs.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.outputs).optionallyWith(cloudWatchLoggingOptions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cloudWatchLoggingOptions).optionallyWith(applicationCode.map(value => value: java.lang.String))(_.applicationCode).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateApplicationRequest.ReadOnly = CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateApplicationRequest = CreateApplicationRequest(applicationNameValue, applicationDescriptionValue.map(value => value), inputsValue.map(value => value.map { item => 
      item.editable
    }), outputsValue.map(value => value.map { item => 
      item.editable
    }), cloudWatchLoggingOptionsValue.map(value => value.map { item => 
      item.editable
    }), applicationCodeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def applicationNameValue: primitives.ApplicationName
    def applicationDescriptionValue: scala.Option[primitives.ApplicationDescription]
    def inputsValue: scala.Option[List[Input.ReadOnly]]
    def outputsValue: scala.Option[List[Output.ReadOnly]]
    def cloudWatchLoggingOptionsValue: scala.Option[List[CloudWatchLoggingOption.ReadOnly]]
    def applicationCodeValue: scala.Option[primitives.ApplicationCode]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def applicationDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationDescription] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applicationDescription", applicationDescriptionValue)
    def inputs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Input.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputs", inputsValue)
    def outputs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Output.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("outputs", outputsValue)
    def cloudWatchLoggingOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CloudWatchLoggingOption.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudWatchLoggingOptions", cloudWatchLoggingOptionsValue)
    def applicationCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applicationCode", applicationCodeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest) extends CreateApplicationRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def applicationDescriptionValue: scala.Option[primitives.ApplicationDescription] = scala.Option(impl.applicationDescription()).map(value => value: primitives.ApplicationDescription)
    override def inputsValue: scala.Option[List[Input.ReadOnly]] = scala.Option(impl.inputs()).map(value => value.asScala.map { item => 
      Input.wrap(item)
    }.toList)
    override def outputsValue: scala.Option[List[Output.ReadOnly]] = scala.Option(impl.outputs()).map(value => value.asScala.map { item => 
      Output.wrap(item)
    }.toList)
    override def cloudWatchLoggingOptionsValue: scala.Option[List[CloudWatchLoggingOption.ReadOnly]] = scala.Option(impl.cloudWatchLoggingOptions()).map(value => value.asScala.map { item => 
      CloudWatchLoggingOption.wrap(item)
    }.toList)
    override def applicationCodeValue: scala.Option[primitives.ApplicationCode] = scala.Option(impl.applicationCode()).map(value => value: primitives.ApplicationCode)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest): ReadOnly = new Wrapper(impl)
}