package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateApplicationResponse(applicationSummary: ApplicationSummary) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse.builder().applicationSummary(applicationSummary.buildAwsValue()).build()
  }
  def asReadOnly: CreateApplicationResponse.ReadOnly = CreateApplicationResponse.wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateApplicationResponse = CreateApplicationResponse(applicationSummaryValue.editable)
    def applicationSummaryValue: ApplicationSummary.ReadOnly
    def applicationSummary: ZIO[Any, Nothing, ApplicationSummary.ReadOnly] = ZIO.succeed(applicationSummaryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse) extends CreateApplicationResponse.ReadOnly { override def applicationSummaryValue: ApplicationSummary.ReadOnly = ApplicationSummary.wrap(impl.applicationSummary()) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse): ReadOnly = new Wrapper(impl)
}