package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteApplicationCloudWatchLoggingOptionRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, cloudWatchLoggingOptionId: primitives.Id) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest = {
    import DeleteApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).cloudWatchLoggingOptionId(cloudWatchLoggingOptionId: java.lang.String).build()
  }
  def asReadOnly: DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly = DeleteApplicationCloudWatchLoggingOptionRequest.wrap(buildAwsValue())
}
object DeleteApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteApplicationCloudWatchLoggingOptionRequest = DeleteApplicationCloudWatchLoggingOptionRequest(applicationNameValue, currentApplicationVersionIdValue, cloudWatchLoggingOptionIdValue)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def cloudWatchLoggingOptionIdValue: primitives.Id
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def cloudWatchLoggingOptionId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(cloudWatchLoggingOptionIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest) extends DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def cloudWatchLoggingOptionIdValue: primitives.Id = impl.cloudWatchLoggingOptionId(): primitives.Id
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest): ReadOnly = new Wrapper(impl)
}