package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteApplicationOutputRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, outputId: primitives.Id) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest = {
    import DeleteApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).outputId(outputId: java.lang.String).build()
  }
  def asReadOnly: DeleteApplicationOutputRequest.ReadOnly = DeleteApplicationOutputRequest.wrap(buildAwsValue())
}
object DeleteApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteApplicationOutputRequest = DeleteApplicationOutputRequest(applicationNameValue, currentApplicationVersionIdValue, outputIdValue)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def outputIdValue: primitives.Id
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def outputId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(outputIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest) extends DeleteApplicationOutputRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def outputIdValue: primitives.Id = impl.outputId(): primitives.Id
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest): ReadOnly = new Wrapper(impl)
}