package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteApplicationReferenceDataSourceRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, referenceId: primitives.Id) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest = {
    import DeleteApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).referenceId(referenceId: java.lang.String).build()
  }
  def asReadOnly: DeleteApplicationReferenceDataSourceRequest.ReadOnly = DeleteApplicationReferenceDataSourceRequest.wrap(buildAwsValue())
}
object DeleteApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteApplicationReferenceDataSourceRequest = DeleteApplicationReferenceDataSourceRequest(applicationNameValue, currentApplicationVersionIdValue, referenceIdValue)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def referenceIdValue: primitives.Id
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def referenceId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(referenceIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest) extends DeleteApplicationReferenceDataSourceRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def referenceIdValue: primitives.Id = impl.referenceId(): primitives.Id
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest): ReadOnly = new Wrapper(impl)
}