package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteApplicationRequest(applicationName: primitives.ApplicationName, createTimestamp: primitives.Timestamp) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest.builder().applicationName(applicationName: java.lang.String).createTimestamp(createTimestamp: java.time.Instant).build()
  }
  def asReadOnly: DeleteApplicationRequest.ReadOnly = DeleteApplicationRequest.wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteApplicationRequest = DeleteApplicationRequest(applicationNameValue, createTimestampValue)
    def applicationNameValue: primitives.ApplicationName
    def createTimestampValue: primitives.Timestamp
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def createTimestamp: ZIO[Any, Nothing, primitives.Timestamp] = ZIO.succeed(createTimestampValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest) extends DeleteApplicationRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def createTimestampValue: primitives.Timestamp = impl.createTimestamp(): primitives.Timestamp
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest): ReadOnly = new Wrapper(impl)
}