package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeApplicationRequest(applicationName: primitives.ApplicationName) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest.builder().applicationName(applicationName: java.lang.String).build()
  }
  def asReadOnly: DescribeApplicationRequest.ReadOnly = DescribeApplicationRequest.wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeApplicationRequest = DescribeApplicationRequest(applicationNameValue)
    def applicationNameValue: primitives.ApplicationName
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest) extends DescribeApplicationRequest.ReadOnly { override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest): ReadOnly = new Wrapper(impl)
}