package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DescribeApplicationResponse(applicationDetail: ApplicationDetail) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse = {
    import DescribeApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse.builder().applicationDetail(applicationDetail.buildAwsValue()).build()
  }
  def asReadOnly: DescribeApplicationResponse.ReadOnly = DescribeApplicationResponse.wrap(buildAwsValue())
}
object DescribeApplicationResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DescribeApplicationResponse = DescribeApplicationResponse(applicationDetailValue.editable)
    def applicationDetailValue: ApplicationDetail.ReadOnly
    def applicationDetail: ZIO[Any, Nothing, ApplicationDetail.ReadOnly] = ZIO.succeed(applicationDetailValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse) extends DescribeApplicationResponse.ReadOnly { override def applicationDetailValue: ApplicationDetail.ReadOnly = ApplicationDetail.wrap(impl.applicationDetail()) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse): ReadOnly = new Wrapper(impl)
}