package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DestinationSchema(recordFormatType: RecordFormatType) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema = {
    import DestinationSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema.builder().recordFormatType(recordFormatType.unwrap).build()
  }
  def asReadOnly: DestinationSchema.ReadOnly = DestinationSchema.wrap(buildAwsValue())
}
object DestinationSchema {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DestinationSchema = DestinationSchema(recordFormatTypeValue)
    def recordFormatTypeValue: RecordFormatType
    def recordFormatType: ZIO[Any, Nothing, RecordFormatType] = ZIO.succeed(recordFormatTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema) extends DestinationSchema.ReadOnly { override def recordFormatTypeValue: RecordFormatType = RecordFormatType.wrap(impl.recordFormatType()) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema): ReadOnly = new Wrapper(impl)
}