package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiscoverInputSchemaRequest(resourceARN: scala.Option[primitives.ResourceARN] = None, roleARN: scala.Option[primitives.RoleARN] = None, inputStartingPositionConfiguration: scala.Option[InputStartingPositionConfiguration] = None, s3Configuration: scala.Option[S3Configuration] = None, inputProcessingConfiguration: scala.Option[InputProcessingConfiguration] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest = {
    import DiscoverInputSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest.builder().optionallyWith(resourceARN.map(value => value: java.lang.String))(_.resourceARN).optionallyWith(roleARN.map(value => value: java.lang.String))(_.roleARN).optionallyWith(inputStartingPositionConfiguration.map(value => value.buildAwsValue()))(_.inputStartingPositionConfiguration).optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(_.s3Configuration).optionallyWith(inputProcessingConfiguration.map(value => value.buildAwsValue()))(_.inputProcessingConfiguration).build()
  }
  def asReadOnly: DiscoverInputSchemaRequest.ReadOnly = DiscoverInputSchemaRequest.wrap(buildAwsValue())
}
object DiscoverInputSchemaRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiscoverInputSchemaRequest = DiscoverInputSchemaRequest(resourceARNValue.map(value => value), roleARNValue.map(value => value), inputStartingPositionConfigurationValue.map(value => value.editable), s3ConfigurationValue.map(value => value.editable), inputProcessingConfigurationValue.map(value => value.editable))
    def resourceARNValue: scala.Option[primitives.ResourceARN]
    def roleARNValue: scala.Option[primitives.RoleARN]
    def inputStartingPositionConfigurationValue: scala.Option[InputStartingPositionConfiguration.ReadOnly]
    def s3ConfigurationValue: scala.Option[S3Configuration.ReadOnly]
    def inputProcessingConfigurationValue: scala.Option[InputProcessingConfiguration.ReadOnly]
    def resourceARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceARN", resourceARNValue)
    def roleARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARN", roleARNValue)
    def inputStartingPositionConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputStartingPositionConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputStartingPositionConfiguration", inputStartingPositionConfigurationValue)
    def s3Configuration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, S3Configuration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Configuration", s3ConfigurationValue)
    def inputProcessingConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputProcessingConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputProcessingConfiguration", inputProcessingConfigurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest) extends DiscoverInputSchemaRequest.ReadOnly {
    override def resourceARNValue: scala.Option[primitives.ResourceARN] = scala.Option(impl.resourceARN()).map(value => value: primitives.ResourceARN)
    override def roleARNValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARN()).map(value => value: primitives.RoleARN)
    override def inputStartingPositionConfigurationValue: scala.Option[InputStartingPositionConfiguration.ReadOnly] = scala.Option(impl.inputStartingPositionConfiguration()).map(value => InputStartingPositionConfiguration.wrap(value))
    override def s3ConfigurationValue: scala.Option[S3Configuration.ReadOnly] = scala.Option(impl.s3Configuration()).map(value => S3Configuration.wrap(value))
    override def inputProcessingConfigurationValue: scala.Option[InputProcessingConfiguration.ReadOnly] = scala.Option(impl.inputProcessingConfiguration()).map(value => InputProcessingConfiguration.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest): ReadOnly = new Wrapper(impl)
}