package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DiscoverInputSchemaResponse(inputSchema: scala.Option[SourceSchema] = None, parsedInputRecords: scala.Option[Iterable[Iterable[primitives.ParsedInputRecordField]]] = None, processedInputRecords: scala.Option[Iterable[primitives.ProcessedInputRecord]] = None, rawInputRecords: scala.Option[Iterable[primitives.RawInputRecord]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse = {
    import DiscoverInputSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse.builder().optionallyWith(inputSchema.map(value => value.buildAwsValue()))(_.inputSchema).optionallyWith(parsedInputRecords.map(value => value.map { item => 
      item.map { item => 
        item: java.lang.String
      }.asJavaCollection
    }.asJavaCollection))(_.parsedInputRecords).optionallyWith(processedInputRecords.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.processedInputRecords).optionallyWith(rawInputRecords.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.rawInputRecords).build()
  }
  def asReadOnly: DiscoverInputSchemaResponse.ReadOnly = DiscoverInputSchemaResponse.wrap(buildAwsValue())
}
object DiscoverInputSchemaResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DiscoverInputSchemaResponse = DiscoverInputSchemaResponse(inputSchemaValue.map(value => value.editable), parsedInputRecordsValue.map(value => value), processedInputRecordsValue.map(value => value), rawInputRecordsValue.map(value => value))
    def inputSchemaValue: scala.Option[SourceSchema.ReadOnly]
    def parsedInputRecordsValue: scala.Option[List[List[primitives.ParsedInputRecordField]]]
    def processedInputRecordsValue: scala.Option[List[primitives.ProcessedInputRecord]]
    def rawInputRecordsValue: scala.Option[List[primitives.RawInputRecord]]
    def inputSchema: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputSchema", inputSchemaValue)
    def parsedInputRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[List[primitives.ParsedInputRecordField]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parsedInputRecords", parsedInputRecordsValue)
    def processedInputRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.ProcessedInputRecord]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processedInputRecords", processedInputRecordsValue)
    def rawInputRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.RawInputRecord]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rawInputRecords", rawInputRecordsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse) extends DiscoverInputSchemaResponse.ReadOnly {
    override def inputSchemaValue: scala.Option[SourceSchema.ReadOnly] = scala.Option(impl.inputSchema()).map(value => SourceSchema.wrap(value))
    override def parsedInputRecordsValue: scala.Option[List[List[primitives.ParsedInputRecordField]]] = scala.Option(impl.parsedInputRecords()).map(value => value.asScala.map { item => 
      item.asScala.map { item => 
        item: primitives.ParsedInputRecordField
      }.toList
    }.toList)
    override def processedInputRecordsValue: scala.Option[List[primitives.ProcessedInputRecord]] = scala.Option(impl.processedInputRecords()).map(value => value.asScala.map { item => 
      item: primitives.ProcessedInputRecord
    }.toList)
    override def rawInputRecordsValue: scala.Option[List[primitives.RawInputRecord]] = scala.Option(impl.rawInputRecords()).map(value => value.asScala.map { item => 
      item: primitives.RawInputRecord
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse): ReadOnly = new Wrapper(impl)
}