package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Input(namePrefix: primitives.InAppStreamName, inputProcessingConfiguration: scala.Option[InputProcessingConfiguration] = None, kinesisStreamsInput: scala.Option[KinesisStreamsInput] = None, kinesisFirehoseInput: scala.Option[KinesisFirehoseInput] = None, inputParallelism: scala.Option[InputParallelism] = None, inputSchema: SourceSchema) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Input.builder().namePrefix(namePrefix: java.lang.String).optionallyWith(inputProcessingConfiguration.map(value => value.buildAwsValue()))(_.inputProcessingConfiguration).optionallyWith(kinesisStreamsInput.map(value => value.buildAwsValue()))(_.kinesisStreamsInput).optionallyWith(kinesisFirehoseInput.map(value => value.buildAwsValue()))(_.kinesisFirehoseInput).optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(_.inputParallelism).inputSchema(inputSchema.buildAwsValue()).build()
  }
  def asReadOnly: Input.ReadOnly = Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.Input] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Input = Input(namePrefixValue, inputProcessingConfigurationValue.map(value => value.editable), kinesisStreamsInputValue.map(value => value.editable), kinesisFirehoseInputValue.map(value => value.editable), inputParallelismValue.map(value => value.editable), inputSchemaValue.editable)
    def namePrefixValue: primitives.InAppStreamName
    def inputProcessingConfigurationValue: scala.Option[InputProcessingConfiguration.ReadOnly]
    def kinesisStreamsInputValue: scala.Option[KinesisStreamsInput.ReadOnly]
    def kinesisFirehoseInputValue: scala.Option[KinesisFirehoseInput.ReadOnly]
    def inputParallelismValue: scala.Option[InputParallelism.ReadOnly]
    def inputSchemaValue: SourceSchema.ReadOnly
    def namePrefix: ZIO[Any, Nothing, primitives.InAppStreamName] = ZIO.succeed(namePrefixValue)
    def inputProcessingConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputProcessingConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputProcessingConfiguration", inputProcessingConfigurationValue)
    def kinesisStreamsInput: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsInput.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsInput", kinesisStreamsInputValue)
    def kinesisFirehoseInput: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseInput.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseInput", kinesisFirehoseInputValue)
    def inputParallelism: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputParallelism.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputParallelism", inputParallelismValue)
    def inputSchema: ZIO[Any, Nothing, SourceSchema.ReadOnly] = ZIO.succeed(inputSchemaValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.Input) extends Input.ReadOnly {
    override def namePrefixValue: primitives.InAppStreamName = impl.namePrefix(): primitives.InAppStreamName
    override def inputProcessingConfigurationValue: scala.Option[InputProcessingConfiguration.ReadOnly] = scala.Option(impl.inputProcessingConfiguration()).map(value => InputProcessingConfiguration.wrap(value))
    override def kinesisStreamsInputValue: scala.Option[KinesisStreamsInput.ReadOnly] = scala.Option(impl.kinesisStreamsInput()).map(value => KinesisStreamsInput.wrap(value))
    override def kinesisFirehoseInputValue: scala.Option[KinesisFirehoseInput.ReadOnly] = scala.Option(impl.kinesisFirehoseInput()).map(value => KinesisFirehoseInput.wrap(value))
    override def inputParallelismValue: scala.Option[InputParallelism.ReadOnly] = scala.Option(impl.inputParallelism()).map(value => InputParallelism.wrap(value))
    override def inputSchemaValue: SourceSchema.ReadOnly = SourceSchema.wrap(impl.inputSchema())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.Input): ReadOnly = new Wrapper(impl)
}