package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputConfiguration(id: primitives.Id, inputStartingPositionConfiguration: InputStartingPositionConfiguration) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration = {
    import InputConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration.builder().id(id: java.lang.String).inputStartingPositionConfiguration(inputStartingPositionConfiguration.buildAwsValue()).build()
  }
  def asReadOnly: InputConfiguration.ReadOnly = InputConfiguration.wrap(buildAwsValue())
}
object InputConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputConfiguration = InputConfiguration(idValue, inputStartingPositionConfigurationValue.editable)
    def idValue: primitives.Id
    def inputStartingPositionConfigurationValue: InputStartingPositionConfiguration.ReadOnly
    def id: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(idValue)
    def inputStartingPositionConfiguration: ZIO[Any, Nothing, InputStartingPositionConfiguration.ReadOnly] = ZIO.succeed(inputStartingPositionConfigurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration) extends InputConfiguration.ReadOnly {
    override def idValue: primitives.Id = impl.id(): primitives.Id
    override def inputStartingPositionConfigurationValue: InputStartingPositionConfiguration.ReadOnly = InputStartingPositionConfiguration.wrap(impl.inputStartingPositionConfiguration())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration): ReadOnly = new Wrapper(impl)
}