package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputDescription(inputId: scala.Option[primitives.Id] = None, namePrefix: scala.Option[primitives.InAppStreamName] = None, inAppStreamNames: scala.Option[Iterable[primitives.InAppStreamName]] = None, inputProcessingConfigurationDescription: scala.Option[InputProcessingConfigurationDescription] = None, kinesisStreamsInputDescription: scala.Option[KinesisStreamsInputDescription] = None, kinesisFirehoseInputDescription: scala.Option[KinesisFirehoseInputDescription] = None, inputSchema: scala.Option[SourceSchema] = None, inputParallelism: scala.Option[InputParallelism] = None, inputStartingPositionConfiguration: scala.Option[InputStartingPositionConfiguration] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputDescription = {
    import InputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputDescription.builder().optionallyWith(inputId.map(value => value: java.lang.String))(_.inputId).optionallyWith(namePrefix.map(value => value: java.lang.String))(_.namePrefix).optionallyWith(inAppStreamNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.inAppStreamNames).optionallyWith(inputProcessingConfigurationDescription.map(value => value.buildAwsValue()))(_.inputProcessingConfigurationDescription).optionallyWith(kinesisStreamsInputDescription.map(value => value.buildAwsValue()))(_.kinesisStreamsInputDescription).optionallyWith(kinesisFirehoseInputDescription.map(value => value.buildAwsValue()))(_.kinesisFirehoseInputDescription).optionallyWith(inputSchema.map(value => value.buildAwsValue()))(_.inputSchema).optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(_.inputParallelism).optionallyWith(inputStartingPositionConfiguration.map(value => value.buildAwsValue()))(_.inputStartingPositionConfiguration).build()
  }
  def asReadOnly: InputDescription.ReadOnly = InputDescription.wrap(buildAwsValue())
}
object InputDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputDescription = InputDescription(inputIdValue.map(value => value), namePrefixValue.map(value => value), inAppStreamNamesValue.map(value => value), inputProcessingConfigurationDescriptionValue.map(value => value.editable), kinesisStreamsInputDescriptionValue.map(value => value.editable), kinesisFirehoseInputDescriptionValue.map(value => value.editable), inputSchemaValue.map(value => value.editable), inputParallelismValue.map(value => value.editable), inputStartingPositionConfigurationValue.map(value => value.editable))
    def inputIdValue: scala.Option[primitives.Id]
    def namePrefixValue: scala.Option[primitives.InAppStreamName]
    def inAppStreamNamesValue: scala.Option[List[primitives.InAppStreamName]]
    def inputProcessingConfigurationDescriptionValue: scala.Option[InputProcessingConfigurationDescription.ReadOnly]
    def kinesisStreamsInputDescriptionValue: scala.Option[KinesisStreamsInputDescription.ReadOnly]
    def kinesisFirehoseInputDescriptionValue: scala.Option[KinesisFirehoseInputDescription.ReadOnly]
    def inputSchemaValue: scala.Option[SourceSchema.ReadOnly]
    def inputParallelismValue: scala.Option[InputParallelism.ReadOnly]
    def inputStartingPositionConfigurationValue: scala.Option[InputStartingPositionConfiguration.ReadOnly]
    def inputId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Id] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputId", inputIdValue)
    def namePrefix: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InAppStreamName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("namePrefix", namePrefixValue)
    def inAppStreamNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.InAppStreamName]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inAppStreamNames", inAppStreamNamesValue)
    def inputProcessingConfigurationDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputProcessingConfigurationDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputProcessingConfigurationDescription", inputProcessingConfigurationDescriptionValue)
    def kinesisStreamsInputDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsInputDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsInputDescription", kinesisStreamsInputDescriptionValue)
    def kinesisFirehoseInputDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseInputDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseInputDescription", kinesisFirehoseInputDescriptionValue)
    def inputSchema: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputSchema", inputSchemaValue)
    def inputParallelism: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputParallelism.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputParallelism", inputParallelismValue)
    def inputStartingPositionConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputStartingPositionConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputStartingPositionConfiguration", inputStartingPositionConfigurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription) extends InputDescription.ReadOnly {
    override def inputIdValue: scala.Option[primitives.Id] = scala.Option(impl.inputId()).map(value => value: primitives.Id)
    override def namePrefixValue: scala.Option[primitives.InAppStreamName] = scala.Option(impl.namePrefix()).map(value => value: primitives.InAppStreamName)
    override def inAppStreamNamesValue: scala.Option[List[primitives.InAppStreamName]] = scala.Option(impl.inAppStreamNames()).map(value => value.asScala.map { item => 
      item: primitives.InAppStreamName
    }.toList)
    override def inputProcessingConfigurationDescriptionValue: scala.Option[InputProcessingConfigurationDescription.ReadOnly] = scala.Option(impl.inputProcessingConfigurationDescription()).map(value => InputProcessingConfigurationDescription.wrap(value))
    override def kinesisStreamsInputDescriptionValue: scala.Option[KinesisStreamsInputDescription.ReadOnly] = scala.Option(impl.kinesisStreamsInputDescription()).map(value => KinesisStreamsInputDescription.wrap(value))
    override def kinesisFirehoseInputDescriptionValue: scala.Option[KinesisFirehoseInputDescription.ReadOnly] = scala.Option(impl.kinesisFirehoseInputDescription()).map(value => KinesisFirehoseInputDescription.wrap(value))
    override def inputSchemaValue: scala.Option[SourceSchema.ReadOnly] = scala.Option(impl.inputSchema()).map(value => SourceSchema.wrap(value))
    override def inputParallelismValue: scala.Option[InputParallelism.ReadOnly] = scala.Option(impl.inputParallelism()).map(value => InputParallelism.wrap(value))
    override def inputStartingPositionConfigurationValue: scala.Option[InputStartingPositionConfiguration.ReadOnly] = scala.Option(impl.inputStartingPositionConfiguration()).map(value => InputStartingPositionConfiguration.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputDescription): ReadOnly = new Wrapper(impl)
}