package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputLambdaProcessorUpdate(resourceARNUpdate: scala.Option[primitives.ResourceARN] = None, roleARNUpdate: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate = {
    import InputLambdaProcessorUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate.builder().optionallyWith(resourceARNUpdate.map(value => value: java.lang.String))(_.resourceARNUpdate).optionallyWith(roleARNUpdate.map(value => value: java.lang.String))(_.roleARNUpdate).build()
  }
  def asReadOnly: InputLambdaProcessorUpdate.ReadOnly = InputLambdaProcessorUpdate.wrap(buildAwsValue())
}
object InputLambdaProcessorUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputLambdaProcessorUpdate = InputLambdaProcessorUpdate(resourceARNUpdateValue.map(value => value), roleARNUpdateValue.map(value => value))
    def resourceARNUpdateValue: scala.Option[primitives.ResourceARN]
    def roleARNUpdateValue: scala.Option[primitives.RoleARN]
    def resourceARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceARNUpdate", resourceARNUpdateValue)
    def roleARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate) extends InputLambdaProcessorUpdate.ReadOnly {
    override def resourceARNUpdateValue: scala.Option[primitives.ResourceARN] = scala.Option(impl.resourceARNUpdate()).map(value => value: primitives.ResourceARN)
    override def roleARNUpdateValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARNUpdate()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputLambdaProcessorUpdate): ReadOnly = new Wrapper(impl)
}