package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputParallelism(count: scala.Option[primitives.InputParallelismCount] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism = {
    import InputParallelism.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism.builder().optionallyWith(count.map(value => value: java.lang.Integer))(_.count).build()
  }
  def asReadOnly: InputParallelism.ReadOnly = InputParallelism.wrap(buildAwsValue())
}
object InputParallelism {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputParallelism = InputParallelism(countValue.map(value => value))
    def countValue: scala.Option[primitives.InputParallelismCount]
    def count: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InputParallelismCount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("count", countValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism) extends InputParallelism.ReadOnly { override def countValue: scala.Option[primitives.InputParallelismCount] = scala.Option(impl.count()).map(value => value: primitives.InputParallelismCount) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelism): ReadOnly = new Wrapper(impl)
}