package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputParallelismUpdate(countUpdate: scala.Option[primitives.InputParallelismCount] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate = {
    import InputParallelismUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate.builder().optionallyWith(countUpdate.map(value => value: java.lang.Integer))(_.countUpdate).build()
  }
  def asReadOnly: InputParallelismUpdate.ReadOnly = InputParallelismUpdate.wrap(buildAwsValue())
}
object InputParallelismUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputParallelismUpdate = InputParallelismUpdate(countUpdateValue.map(value => value))
    def countUpdateValue: scala.Option[primitives.InputParallelismCount]
    def countUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InputParallelismCount] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("countUpdate", countUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate) extends InputParallelismUpdate.ReadOnly { override def countUpdateValue: scala.Option[primitives.InputParallelismCount] = scala.Option(impl.countUpdate()).map(value => value: primitives.InputParallelismCount) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate): ReadOnly = new Wrapper(impl)
}