package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputProcessingConfiguration(inputLambdaProcessor: InputLambdaProcessor) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration = {
    import InputProcessingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration.builder().inputLambdaProcessor(inputLambdaProcessor.buildAwsValue()).build()
  }
  def asReadOnly: InputProcessingConfiguration.ReadOnly = InputProcessingConfiguration.wrap(buildAwsValue())
}
object InputProcessingConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputProcessingConfiguration = InputProcessingConfiguration(inputLambdaProcessorValue.editable)
    def inputLambdaProcessorValue: InputLambdaProcessor.ReadOnly
    def inputLambdaProcessor: ZIO[Any, Nothing, InputLambdaProcessor.ReadOnly] = ZIO.succeed(inputLambdaProcessorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration) extends InputProcessingConfiguration.ReadOnly { override def inputLambdaProcessorValue: InputLambdaProcessor.ReadOnly = InputLambdaProcessor.wrap(impl.inputLambdaProcessor()) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfiguration): ReadOnly = new Wrapper(impl)
}