package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputProcessingConfigurationDescription(inputLambdaProcessorDescription: scala.Option[InputLambdaProcessorDescription] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription = {
    import InputProcessingConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription.builder().optionallyWith(inputLambdaProcessorDescription.map(value => value.buildAwsValue()))(_.inputLambdaProcessorDescription).build()
  }
  def asReadOnly: InputProcessingConfigurationDescription.ReadOnly = InputProcessingConfigurationDescription.wrap(buildAwsValue())
}
object InputProcessingConfigurationDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputProcessingConfigurationDescription = InputProcessingConfigurationDescription(inputLambdaProcessorDescriptionValue.map(value => value.editable))
    def inputLambdaProcessorDescriptionValue: scala.Option[InputLambdaProcessorDescription.ReadOnly]
    def inputLambdaProcessorDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputLambdaProcessorDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputLambdaProcessorDescription", inputLambdaProcessorDescriptionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription) extends InputProcessingConfigurationDescription.ReadOnly { override def inputLambdaProcessorDescriptionValue: scala.Option[InputLambdaProcessorDescription.ReadOnly] = scala.Option(impl.inputLambdaProcessorDescription()).map(value => InputLambdaProcessorDescription.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputProcessingConfigurationDescription): ReadOnly = new Wrapper(impl)
}