package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputSchemaUpdate(recordFormatUpdate: scala.Option[RecordFormat] = None, recordEncodingUpdate: scala.Option[primitives.RecordEncoding] = None, recordColumnUpdates: scala.Option[Iterable[RecordColumn]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate = {
    import InputSchemaUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate.builder().optionallyWith(recordFormatUpdate.map(value => value.buildAwsValue()))(_.recordFormatUpdate).optionallyWith(recordEncodingUpdate.map(value => value: java.lang.String))(_.recordEncodingUpdate).optionallyWith(recordColumnUpdates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.recordColumnUpdates).build()
  }
  def asReadOnly: InputSchemaUpdate.ReadOnly = InputSchemaUpdate.wrap(buildAwsValue())
}
object InputSchemaUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputSchemaUpdate = InputSchemaUpdate(recordFormatUpdateValue.map(value => value.editable), recordEncodingUpdateValue.map(value => value), recordColumnUpdatesValue.map(value => value.map { item => 
      item.editable
    }))
    def recordFormatUpdateValue: scala.Option[RecordFormat.ReadOnly]
    def recordEncodingUpdateValue: scala.Option[primitives.RecordEncoding]
    def recordColumnUpdatesValue: scala.Option[List[RecordColumn.ReadOnly]]
    def recordFormatUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RecordFormat.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recordFormatUpdate", recordFormatUpdateValue)
    def recordEncodingUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RecordEncoding] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recordEncodingUpdate", recordEncodingUpdateValue)
    def recordColumnUpdates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RecordColumn.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recordColumnUpdates", recordColumnUpdatesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate) extends InputSchemaUpdate.ReadOnly {
    override def recordFormatUpdateValue: scala.Option[RecordFormat.ReadOnly] = scala.Option(impl.recordFormatUpdate()).map(value => RecordFormat.wrap(value))
    override def recordEncodingUpdateValue: scala.Option[primitives.RecordEncoding] = scala.Option(impl.recordEncodingUpdate()).map(value => value: primitives.RecordEncoding)
    override def recordColumnUpdatesValue: scala.Option[List[RecordColumn.ReadOnly]] = scala.Option(impl.recordColumnUpdates()).map(value => value.asScala.map { item => 
      RecordColumn.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate): ReadOnly = new Wrapper(impl)
}