package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait InputStartingPosition { def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition }
object InputStartingPosition {
  def wrap(value: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition): InputStartingPosition = value match {
    case software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.NOW =>
      val r = NOW
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.TRIM_HORIZON =>
      val r = TRIM_HORIZON
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.LAST_STOPPED_POINT =>
      val r = LAST_STOPPED_POINT
      r
  }
  case object unknownToSdkVersion extends InputStartingPosition { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition = software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.UNKNOWN_TO_SDK_VERSION }
  case object NOW extends InputStartingPosition { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition = software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.NOW }
  case object TRIM_HORIZON extends InputStartingPosition { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition = software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.TRIM_HORIZON }
  case object LAST_STOPPED_POINT extends InputStartingPosition { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition = software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPosition.LAST_STOPPED_POINT }
}