package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputStartingPositionConfiguration(inputStartingPosition: scala.Option[InputStartingPosition] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration = {
    import InputStartingPositionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration.builder().optionallyWith(inputStartingPosition.map(value => value.unwrap))(_.inputStartingPosition).build()
  }
  def asReadOnly: InputStartingPositionConfiguration.ReadOnly = InputStartingPositionConfiguration.wrap(buildAwsValue())
}
object InputStartingPositionConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputStartingPositionConfiguration = InputStartingPositionConfiguration(inputStartingPositionValue.map(value => value))
    def inputStartingPositionValue: scala.Option[InputStartingPosition]
    def inputStartingPosition: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputStartingPosition] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputStartingPosition", inputStartingPositionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration) extends InputStartingPositionConfiguration.ReadOnly { override def inputStartingPositionValue: scala.Option[InputStartingPosition] = scala.Option(impl.inputStartingPosition()).map(value => InputStartingPosition.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputStartingPositionConfiguration): ReadOnly = new Wrapper(impl)
}