package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InputUpdate(inputId: primitives.Id, namePrefixUpdate: scala.Option[primitives.InAppStreamName] = None, inputProcessingConfigurationUpdate: scala.Option[InputProcessingConfigurationUpdate] = None, kinesisStreamsInputUpdate: scala.Option[KinesisStreamsInputUpdate] = None, kinesisFirehoseInputUpdate: scala.Option[KinesisFirehoseInputUpdate] = None, inputSchemaUpdate: scala.Option[InputSchemaUpdate] = None, inputParallelismUpdate: scala.Option[InputParallelismUpdate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate = {
    import InputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate.builder().inputId(inputId: java.lang.String).optionallyWith(namePrefixUpdate.map(value => value: java.lang.String))(_.namePrefixUpdate).optionallyWith(inputProcessingConfigurationUpdate.map(value => value.buildAwsValue()))(_.inputProcessingConfigurationUpdate).optionallyWith(kinesisStreamsInputUpdate.map(value => value.buildAwsValue()))(_.kinesisStreamsInputUpdate).optionallyWith(kinesisFirehoseInputUpdate.map(value => value.buildAwsValue()))(_.kinesisFirehoseInputUpdate).optionallyWith(inputSchemaUpdate.map(value => value.buildAwsValue()))(_.inputSchemaUpdate).optionallyWith(inputParallelismUpdate.map(value => value.buildAwsValue()))(_.inputParallelismUpdate).build()
  }
  def asReadOnly: InputUpdate.ReadOnly = InputUpdate.wrap(buildAwsValue())
}
object InputUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InputUpdate = InputUpdate(inputIdValue, namePrefixUpdateValue.map(value => value), inputProcessingConfigurationUpdateValue.map(value => value.editable), kinesisStreamsInputUpdateValue.map(value => value.editable), kinesisFirehoseInputUpdateValue.map(value => value.editable), inputSchemaUpdateValue.map(value => value.editable), inputParallelismUpdateValue.map(value => value.editable))
    def inputIdValue: primitives.Id
    def namePrefixUpdateValue: scala.Option[primitives.InAppStreamName]
    def inputProcessingConfigurationUpdateValue: scala.Option[InputProcessingConfigurationUpdate.ReadOnly]
    def kinesisStreamsInputUpdateValue: scala.Option[KinesisStreamsInputUpdate.ReadOnly]
    def kinesisFirehoseInputUpdateValue: scala.Option[KinesisFirehoseInputUpdate.ReadOnly]
    def inputSchemaUpdateValue: scala.Option[InputSchemaUpdate.ReadOnly]
    def inputParallelismUpdateValue: scala.Option[InputParallelismUpdate.ReadOnly]
    def inputId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(inputIdValue)
    def namePrefixUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InAppStreamName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("namePrefixUpdate", namePrefixUpdateValue)
    def inputProcessingConfigurationUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputProcessingConfigurationUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputProcessingConfigurationUpdate", inputProcessingConfigurationUpdateValue)
    def kinesisStreamsInputUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsInputUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsInputUpdate", kinesisStreamsInputUpdateValue)
    def kinesisFirehoseInputUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseInputUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseInputUpdate", kinesisFirehoseInputUpdateValue)
    def inputSchemaUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputSchemaUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputSchemaUpdate", inputSchemaUpdateValue)
    def inputParallelismUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputParallelismUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("inputParallelismUpdate", inputParallelismUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate) extends InputUpdate.ReadOnly {
    override def inputIdValue: primitives.Id = impl.inputId(): primitives.Id
    override def namePrefixUpdateValue: scala.Option[primitives.InAppStreamName] = scala.Option(impl.namePrefixUpdate()).map(value => value: primitives.InAppStreamName)
    override def inputProcessingConfigurationUpdateValue: scala.Option[InputProcessingConfigurationUpdate.ReadOnly] = scala.Option(impl.inputProcessingConfigurationUpdate()).map(value => InputProcessingConfigurationUpdate.wrap(value))
    override def kinesisStreamsInputUpdateValue: scala.Option[KinesisStreamsInputUpdate.ReadOnly] = scala.Option(impl.kinesisStreamsInputUpdate()).map(value => KinesisStreamsInputUpdate.wrap(value))
    override def kinesisFirehoseInputUpdateValue: scala.Option[KinesisFirehoseInputUpdate.ReadOnly] = scala.Option(impl.kinesisFirehoseInputUpdate()).map(value => KinesisFirehoseInputUpdate.wrap(value))
    override def inputSchemaUpdateValue: scala.Option[InputSchemaUpdate.ReadOnly] = scala.Option(impl.inputSchemaUpdate()).map(value => InputSchemaUpdate.wrap(value))
    override def inputParallelismUpdateValue: scala.Option[InputParallelismUpdate.ReadOnly] = scala.Option(impl.inputParallelismUpdate()).map(value => InputParallelismUpdate.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate): ReadOnly = new Wrapper(impl)
}