package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class KinesisFirehoseInputDescription(resourceARN: scala.Option[primitives.ResourceARN] = None, roleARN: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription = {
    import KinesisFirehoseInputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription.builder().optionallyWith(resourceARN.map(value => value: java.lang.String))(_.resourceARN).optionallyWith(roleARN.map(value => value: java.lang.String))(_.roleARN).build()
  }
  def asReadOnly: KinesisFirehoseInputDescription.ReadOnly = KinesisFirehoseInputDescription.wrap(buildAwsValue())
}
object KinesisFirehoseInputDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: KinesisFirehoseInputDescription = KinesisFirehoseInputDescription(resourceARNValue.map(value => value), roleARNValue.map(value => value))
    def resourceARNValue: scala.Option[primitives.ResourceARN]
    def roleARNValue: scala.Option[primitives.RoleARN]
    def resourceARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceARN", resourceARNValue)
    def roleARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARN", roleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription) extends KinesisFirehoseInputDescription.ReadOnly {
    override def resourceARNValue: scala.Option[primitives.ResourceARN] = scala.Option(impl.resourceARN()).map(value => value: primitives.ResourceARN)
    override def roleARNValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARN()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputDescription): ReadOnly = new Wrapper(impl)
}