package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class KinesisStreamsInputUpdate(resourceARNUpdate: scala.Option[primitives.ResourceARN] = None, roleARNUpdate: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate = {
    import KinesisStreamsInputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate.builder().optionallyWith(resourceARNUpdate.map(value => value: java.lang.String))(_.resourceARNUpdate).optionallyWith(roleARNUpdate.map(value => value: java.lang.String))(_.roleARNUpdate).build()
  }
  def asReadOnly: KinesisStreamsInputUpdate.ReadOnly = KinesisStreamsInputUpdate.wrap(buildAwsValue())
}
object KinesisStreamsInputUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: KinesisStreamsInputUpdate = KinesisStreamsInputUpdate(resourceARNUpdateValue.map(value => value), roleARNUpdateValue.map(value => value))
    def resourceARNUpdateValue: scala.Option[primitives.ResourceARN]
    def roleARNUpdateValue: scala.Option[primitives.RoleARN]
    def resourceARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceARNUpdate", resourceARNUpdateValue)
    def roleARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARNUpdate", roleARNUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate) extends KinesisStreamsInputUpdate.ReadOnly {
    override def resourceARNUpdateValue: scala.Option[primitives.ResourceARN] = scala.Option(impl.resourceARNUpdate()).map(value => value: primitives.ResourceARN)
    override def roleARNUpdateValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARNUpdate()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate): ReadOnly = new Wrapper(impl)
}