package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class KinesisStreamsOutputDescription(resourceARN: scala.Option[primitives.ResourceARN] = None, roleARN: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription = {
    import KinesisStreamsOutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription.builder().optionallyWith(resourceARN.map(value => value: java.lang.String))(_.resourceARN).optionallyWith(roleARN.map(value => value: java.lang.String))(_.roleARN).build()
  }
  def asReadOnly: KinesisStreamsOutputDescription.ReadOnly = KinesisStreamsOutputDescription.wrap(buildAwsValue())
}
object KinesisStreamsOutputDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: KinesisStreamsOutputDescription = KinesisStreamsOutputDescription(resourceARNValue.map(value => value), roleARNValue.map(value => value))
    def resourceARNValue: scala.Option[primitives.ResourceARN]
    def roleARNValue: scala.Option[primitives.RoleARN]
    def resourceARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceARN", resourceARNValue)
    def roleARN: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleARN", roleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription) extends KinesisStreamsOutputDescription.ReadOnly {
    override def resourceARNValue: scala.Option[primitives.ResourceARN] = scala.Option(impl.resourceARN()).map(value => value: primitives.ResourceARN)
    override def roleARNValue: scala.Option[primitives.RoleARN] = scala.Option(impl.roleARN()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription): ReadOnly = new Wrapper(impl)
}