package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LambdaOutput(resourceARN: primitives.ResourceARN, roleARN: primitives.RoleARN) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput = {
    import LambdaOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput.builder().resourceARN(resourceARN: java.lang.String).roleARN(roleARN: java.lang.String).build()
  }
  def asReadOnly: LambdaOutput.ReadOnly = LambdaOutput.wrap(buildAwsValue())
}
object LambdaOutput {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LambdaOutput = LambdaOutput(resourceARNValue, roleARNValue)
    def resourceARNValue: primitives.ResourceARN
    def roleARNValue: primitives.RoleARN
    def resourceARN: ZIO[Any, Nothing, primitives.ResourceARN] = ZIO.succeed(resourceARNValue)
    def roleARN: ZIO[Any, Nothing, primitives.RoleARN] = ZIO.succeed(roleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput) extends LambdaOutput.ReadOnly {
    override def resourceARNValue: primitives.ResourceARN = impl.resourceARN(): primitives.ResourceARN
    override def roleARNValue: primitives.RoleARN = impl.roleARN(): primitives.RoleARN
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.LambdaOutput): ReadOnly = new Wrapper(impl)
}