package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListApplicationsRequest(limit: scala.Option[primitives.ListApplicationsInputLimit] = None, exclusiveStartApplicationName: scala.Option[primitives.ApplicationName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest.builder().optionallyWith(limit.map(value => value: java.lang.Integer))(_.limit).optionallyWith(exclusiveStartApplicationName.map(value => value: java.lang.String))(_.exclusiveStartApplicationName).build()
  }
  def asReadOnly: ListApplicationsRequest.ReadOnly = ListApplicationsRequest.wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListApplicationsRequest = ListApplicationsRequest(limitValue.map(value => value), exclusiveStartApplicationNameValue.map(value => value))
    def limitValue: scala.Option[primitives.ListApplicationsInputLimit]
    def exclusiveStartApplicationNameValue: scala.Option[primitives.ApplicationName]
    def limit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ListApplicationsInputLimit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("limit", limitValue)
    def exclusiveStartApplicationName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ApplicationName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exclusiveStartApplicationName", exclusiveStartApplicationNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest) extends ListApplicationsRequest.ReadOnly {
    override def limitValue: scala.Option[primitives.ListApplicationsInputLimit] = scala.Option(impl.limit()).map(value => value: primitives.ListApplicationsInputLimit)
    override def exclusiveStartApplicationNameValue: scala.Option[primitives.ApplicationName] = scala.Option(impl.exclusiveStartApplicationName()).map(value => value: primitives.ApplicationName)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest): ReadOnly = new Wrapper(impl)
}