package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListApplicationsResponse(applicationSummaries: Iterable[ApplicationSummary], hasMoreApplications: primitives.BooleanObject) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse.builder().applicationSummaries(applicationSummaries.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).hasMoreApplications(hasMoreApplications: java.lang.Boolean).build()
  }
  def asReadOnly: ListApplicationsResponse.ReadOnly = ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListApplicationsResponse = ListApplicationsResponse(applicationSummariesValue.map { item => 
      item.editable
    }, hasMoreApplicationsValue)
    def applicationSummariesValue: List[ApplicationSummary.ReadOnly]
    def hasMoreApplicationsValue: primitives.BooleanObject
    def applicationSummaries: ZIO[Any, Nothing, List[ApplicationSummary.ReadOnly]] = ZIO.succeed(applicationSummariesValue)
    def hasMoreApplications: ZIO[Any, Nothing, primitives.BooleanObject] = ZIO.succeed(hasMoreApplicationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse) extends ListApplicationsResponse.ReadOnly {
    override def applicationSummariesValue: List[ApplicationSummary.ReadOnly] = impl.applicationSummaries().asScala.map { item => 
      ApplicationSummary.wrap(item)
    }.toList
    override def hasMoreApplicationsValue: primitives.BooleanObject = impl.hasMoreApplications(): primitives.BooleanObject
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse): ReadOnly = new Wrapper(impl)
}