package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListTagsForResourceRequest(resourceARN: primitives.KinesisAnalyticsARN) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest.builder().resourceARN(resourceARN: java.lang.String).build()
  }
  def asReadOnly: ListTagsForResourceRequest.ReadOnly = ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListTagsForResourceRequest = ListTagsForResourceRequest(resourceARNValue)
    def resourceARNValue: primitives.KinesisAnalyticsARN
    def resourceARN: ZIO[Any, Nothing, primitives.KinesisAnalyticsARN] = ZIO.succeed(resourceARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest) extends ListTagsForResourceRequest.ReadOnly { override def resourceARNValue: primitives.KinesisAnalyticsARN = impl.resourceARN(): primitives.KinesisAnalyticsARN }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest): ReadOnly = new Wrapper(impl)
}