package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MappingParameters(jsonMappingParameters: scala.Option[JSONMappingParameters] = None, csvMappingParameters: scala.Option[CSVMappingParameters] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters = {
    import MappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters.builder().optionallyWith(jsonMappingParameters.map(value => value.buildAwsValue()))(_.jsonMappingParameters).optionallyWith(csvMappingParameters.map(value => value.buildAwsValue()))(_.csvMappingParameters).build()
  }
  def asReadOnly: MappingParameters.ReadOnly = MappingParameters.wrap(buildAwsValue())
}
object MappingParameters {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MappingParameters = MappingParameters(jsonMappingParametersValue.map(value => value.editable), csvMappingParametersValue.map(value => value.editable))
    def jsonMappingParametersValue: scala.Option[JSONMappingParameters.ReadOnly]
    def csvMappingParametersValue: scala.Option[CSVMappingParameters.ReadOnly]
    def jsonMappingParameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, JSONMappingParameters.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("jsonMappingParameters", jsonMappingParametersValue)
    def csvMappingParameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CSVMappingParameters.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("csvMappingParameters", csvMappingParametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters) extends MappingParameters.ReadOnly {
    override def jsonMappingParametersValue: scala.Option[JSONMappingParameters.ReadOnly] = scala.Option(impl.jsonMappingParameters()).map(value => JSONMappingParameters.wrap(value))
    override def csvMappingParametersValue: scala.Option[CSVMappingParameters.ReadOnly] = scala.Option(impl.csvMappingParameters()).map(value => CSVMappingParameters.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters): ReadOnly = new Wrapper(impl)
}