package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Output(name: primitives.InAppStreamName, kinesisStreamsOutput: scala.Option[KinesisStreamsOutput] = None, kinesisFirehoseOutput: scala.Option[KinesisFirehoseOutput] = None, lambdaOutput: scala.Option[LambdaOutput] = None, destinationSchema: DestinationSchema) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Output.builder().name(name: java.lang.String).optionallyWith(kinesisStreamsOutput.map(value => value.buildAwsValue()))(_.kinesisStreamsOutput).optionallyWith(kinesisFirehoseOutput.map(value => value.buildAwsValue()))(_.kinesisFirehoseOutput).optionallyWith(lambdaOutput.map(value => value.buildAwsValue()))(_.lambdaOutput).destinationSchema(destinationSchema.buildAwsValue()).build()
  }
  def asReadOnly: Output.ReadOnly = Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.Output] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Output = Output(nameValue, kinesisStreamsOutputValue.map(value => value.editable), kinesisFirehoseOutputValue.map(value => value.editable), lambdaOutputValue.map(value => value.editable), destinationSchemaValue.editable)
    def nameValue: primitives.InAppStreamName
    def kinesisStreamsOutputValue: scala.Option[KinesisStreamsOutput.ReadOnly]
    def kinesisFirehoseOutputValue: scala.Option[KinesisFirehoseOutput.ReadOnly]
    def lambdaOutputValue: scala.Option[LambdaOutput.ReadOnly]
    def destinationSchemaValue: DestinationSchema.ReadOnly
    def name: ZIO[Any, Nothing, primitives.InAppStreamName] = ZIO.succeed(nameValue)
    def kinesisStreamsOutput: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsOutput.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsOutput", kinesisStreamsOutputValue)
    def kinesisFirehoseOutput: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseOutput.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseOutput", kinesisFirehoseOutputValue)
    def lambdaOutput: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LambdaOutput.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lambdaOutput", lambdaOutputValue)
    def destinationSchema: ZIO[Any, Nothing, DestinationSchema.ReadOnly] = ZIO.succeed(destinationSchemaValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.Output) extends Output.ReadOnly {
    override def nameValue: primitives.InAppStreamName = impl.name(): primitives.InAppStreamName
    override def kinesisStreamsOutputValue: scala.Option[KinesisStreamsOutput.ReadOnly] = scala.Option(impl.kinesisStreamsOutput()).map(value => KinesisStreamsOutput.wrap(value))
    override def kinesisFirehoseOutputValue: scala.Option[KinesisFirehoseOutput.ReadOnly] = scala.Option(impl.kinesisFirehoseOutput()).map(value => KinesisFirehoseOutput.wrap(value))
    override def lambdaOutputValue: scala.Option[LambdaOutput.ReadOnly] = scala.Option(impl.lambdaOutput()).map(value => LambdaOutput.wrap(value))
    override def destinationSchemaValue: DestinationSchema.ReadOnly = DestinationSchema.wrap(impl.destinationSchema())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.Output): ReadOnly = new Wrapper(impl)
}