package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class OutputDescription(outputId: scala.Option[primitives.Id] = None, name: scala.Option[primitives.InAppStreamName] = None, kinesisStreamsOutputDescription: scala.Option[KinesisStreamsOutputDescription] = None, kinesisFirehoseOutputDescription: scala.Option[KinesisFirehoseOutputDescription] = None, lambdaOutputDescription: scala.Option[LambdaOutputDescription] = None, destinationSchema: scala.Option[DestinationSchema] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription = {
    import OutputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription.builder().optionallyWith(outputId.map(value => value: java.lang.String))(_.outputId).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(kinesisStreamsOutputDescription.map(value => value.buildAwsValue()))(_.kinesisStreamsOutputDescription).optionallyWith(kinesisFirehoseOutputDescription.map(value => value.buildAwsValue()))(_.kinesisFirehoseOutputDescription).optionallyWith(lambdaOutputDescription.map(value => value.buildAwsValue()))(_.lambdaOutputDescription).optionallyWith(destinationSchema.map(value => value.buildAwsValue()))(_.destinationSchema).build()
  }
  def asReadOnly: OutputDescription.ReadOnly = OutputDescription.wrap(buildAwsValue())
}
object OutputDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: OutputDescription = OutputDescription(outputIdValue.map(value => value), nameValue.map(value => value), kinesisStreamsOutputDescriptionValue.map(value => value.editable), kinesisFirehoseOutputDescriptionValue.map(value => value.editable), lambdaOutputDescriptionValue.map(value => value.editable), destinationSchemaValue.map(value => value.editable))
    def outputIdValue: scala.Option[primitives.Id]
    def nameValue: scala.Option[primitives.InAppStreamName]
    def kinesisStreamsOutputDescriptionValue: scala.Option[KinesisStreamsOutputDescription.ReadOnly]
    def kinesisFirehoseOutputDescriptionValue: scala.Option[KinesisFirehoseOutputDescription.ReadOnly]
    def lambdaOutputDescriptionValue: scala.Option[LambdaOutputDescription.ReadOnly]
    def destinationSchemaValue: scala.Option[DestinationSchema.ReadOnly]
    def outputId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Id] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("outputId", outputIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InAppStreamName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def kinesisStreamsOutputDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsOutputDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsOutputDescription", kinesisStreamsOutputDescriptionValue)
    def kinesisFirehoseOutputDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseOutputDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseOutputDescription", kinesisFirehoseOutputDescriptionValue)
    def lambdaOutputDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LambdaOutputDescription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lambdaOutputDescription", lambdaOutputDescriptionValue)
    def destinationSchema: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DestinationSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("destinationSchema", destinationSchemaValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription) extends OutputDescription.ReadOnly {
    override def outputIdValue: scala.Option[primitives.Id] = scala.Option(impl.outputId()).map(value => value: primitives.Id)
    override def nameValue: scala.Option[primitives.InAppStreamName] = scala.Option(impl.name()).map(value => value: primitives.InAppStreamName)
    override def kinesisStreamsOutputDescriptionValue: scala.Option[KinesisStreamsOutputDescription.ReadOnly] = scala.Option(impl.kinesisStreamsOutputDescription()).map(value => KinesisStreamsOutputDescription.wrap(value))
    override def kinesisFirehoseOutputDescriptionValue: scala.Option[KinesisFirehoseOutputDescription.ReadOnly] = scala.Option(impl.kinesisFirehoseOutputDescription()).map(value => KinesisFirehoseOutputDescription.wrap(value))
    override def lambdaOutputDescriptionValue: scala.Option[LambdaOutputDescription.ReadOnly] = scala.Option(impl.lambdaOutputDescription()).map(value => LambdaOutputDescription.wrap(value))
    override def destinationSchemaValue: scala.Option[DestinationSchema.ReadOnly] = scala.Option(impl.destinationSchema()).map(value => DestinationSchema.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputDescription): ReadOnly = new Wrapper(impl)
}