package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class OutputUpdate(outputId: primitives.Id, nameUpdate: scala.Option[primitives.InAppStreamName] = None, kinesisStreamsOutputUpdate: scala.Option[KinesisStreamsOutputUpdate] = None, kinesisFirehoseOutputUpdate: scala.Option[KinesisFirehoseOutputUpdate] = None, lambdaOutputUpdate: scala.Option[LambdaOutputUpdate] = None, destinationSchemaUpdate: scala.Option[DestinationSchema] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate = {
    import OutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate.builder().outputId(outputId: java.lang.String).optionallyWith(nameUpdate.map(value => value: java.lang.String))(_.nameUpdate).optionallyWith(kinesisStreamsOutputUpdate.map(value => value.buildAwsValue()))(_.kinesisStreamsOutputUpdate).optionallyWith(kinesisFirehoseOutputUpdate.map(value => value.buildAwsValue()))(_.kinesisFirehoseOutputUpdate).optionallyWith(lambdaOutputUpdate.map(value => value.buildAwsValue()))(_.lambdaOutputUpdate).optionallyWith(destinationSchemaUpdate.map(value => value.buildAwsValue()))(_.destinationSchemaUpdate).build()
  }
  def asReadOnly: OutputUpdate.ReadOnly = OutputUpdate.wrap(buildAwsValue())
}
object OutputUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: OutputUpdate = OutputUpdate(outputIdValue, nameUpdateValue.map(value => value), kinesisStreamsOutputUpdateValue.map(value => value.editable), kinesisFirehoseOutputUpdateValue.map(value => value.editable), lambdaOutputUpdateValue.map(value => value.editable), destinationSchemaUpdateValue.map(value => value.editable))
    def outputIdValue: primitives.Id
    def nameUpdateValue: scala.Option[primitives.InAppStreamName]
    def kinesisStreamsOutputUpdateValue: scala.Option[KinesisStreamsOutputUpdate.ReadOnly]
    def kinesisFirehoseOutputUpdateValue: scala.Option[KinesisFirehoseOutputUpdate.ReadOnly]
    def lambdaOutputUpdateValue: scala.Option[LambdaOutputUpdate.ReadOnly]
    def destinationSchemaUpdateValue: scala.Option[DestinationSchema.ReadOnly]
    def outputId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(outputIdValue)
    def nameUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InAppStreamName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nameUpdate", nameUpdateValue)
    def kinesisStreamsOutputUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisStreamsOutputUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisStreamsOutputUpdate", kinesisStreamsOutputUpdateValue)
    def kinesisFirehoseOutputUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, KinesisFirehoseOutputUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kinesisFirehoseOutputUpdate", kinesisFirehoseOutputUpdateValue)
    def lambdaOutputUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LambdaOutputUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lambdaOutputUpdate", lambdaOutputUpdateValue)
    def destinationSchemaUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DestinationSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("destinationSchemaUpdate", destinationSchemaUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate) extends OutputUpdate.ReadOnly {
    override def outputIdValue: primitives.Id = impl.outputId(): primitives.Id
    override def nameUpdateValue: scala.Option[primitives.InAppStreamName] = scala.Option(impl.nameUpdate()).map(value => value: primitives.InAppStreamName)
    override def kinesisStreamsOutputUpdateValue: scala.Option[KinesisStreamsOutputUpdate.ReadOnly] = scala.Option(impl.kinesisStreamsOutputUpdate()).map(value => KinesisStreamsOutputUpdate.wrap(value))
    override def kinesisFirehoseOutputUpdateValue: scala.Option[KinesisFirehoseOutputUpdate.ReadOnly] = scala.Option(impl.kinesisFirehoseOutputUpdate()).map(value => KinesisFirehoseOutputUpdate.wrap(value))
    override def lambdaOutputUpdateValue: scala.Option[LambdaOutputUpdate.ReadOnly] = scala.Option(impl.lambdaOutputUpdate()).map(value => LambdaOutputUpdate.wrap(value))
    override def destinationSchemaUpdateValue: scala.Option[DestinationSchema.ReadOnly] = scala.Option(impl.destinationSchemaUpdate()).map(value => DestinationSchema.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate): ReadOnly = new Wrapper(impl)
}