package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RecordColumn(name: primitives.RecordColumnName, mapping: scala.Option[primitives.RecordColumnMapping] = None, sqlType: primitives.RecordColumnSqlType) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn = {
    import RecordColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn.builder().name(name: java.lang.String).optionallyWith(mapping.map(value => value: java.lang.String))(_.mapping).sqlType(sqlType: java.lang.String).build()
  }
  def asReadOnly: RecordColumn.ReadOnly = RecordColumn.wrap(buildAwsValue())
}
object RecordColumn {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RecordColumn = RecordColumn(nameValue, mappingValue.map(value => value), sqlTypeValue)
    def nameValue: primitives.RecordColumnName
    def mappingValue: scala.Option[primitives.RecordColumnMapping]
    def sqlTypeValue: primitives.RecordColumnSqlType
    def name: ZIO[Any, Nothing, primitives.RecordColumnName] = ZIO.succeed(nameValue)
    def mapping: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RecordColumnMapping] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mapping", mappingValue)
    def sqlType: ZIO[Any, Nothing, primitives.RecordColumnSqlType] = ZIO.succeed(sqlTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn) extends RecordColumn.ReadOnly {
    override def nameValue: primitives.RecordColumnName = impl.name(): primitives.RecordColumnName
    override def mappingValue: scala.Option[primitives.RecordColumnMapping] = scala.Option(impl.mapping()).map(value => value: primitives.RecordColumnMapping)
    override def sqlTypeValue: primitives.RecordColumnSqlType = impl.sqlType(): primitives.RecordColumnSqlType
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn): ReadOnly = new Wrapper(impl)
}