package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RecordFormat(recordFormatType: RecordFormatType, mappingParameters: scala.Option[MappingParameters] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat = {
    import RecordFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat.builder().recordFormatType(recordFormatType.unwrap).optionallyWith(mappingParameters.map(value => value.buildAwsValue()))(_.mappingParameters).build()
  }
  def asReadOnly: RecordFormat.ReadOnly = RecordFormat.wrap(buildAwsValue())
}
object RecordFormat {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RecordFormat = RecordFormat(recordFormatTypeValue, mappingParametersValue.map(value => value.editable))
    def recordFormatTypeValue: RecordFormatType
    def mappingParametersValue: scala.Option[MappingParameters.ReadOnly]
    def recordFormatType: ZIO[Any, Nothing, RecordFormatType] = ZIO.succeed(recordFormatTypeValue)
    def mappingParameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MappingParameters.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("mappingParameters", mappingParametersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat) extends RecordFormat.ReadOnly {
    override def recordFormatTypeValue: RecordFormatType = RecordFormatType.wrap(impl.recordFormatType())
    override def mappingParametersValue: scala.Option[MappingParameters.ReadOnly] = scala.Option(impl.mappingParameters()).map(value => MappingParameters.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormat): ReadOnly = new Wrapper(impl)
}